/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics;

import edu.unc.genomics.ValuedInterval;
import edu.unc.genomics.io.IntervalFileFormatException;

public class GFFEntry
extends ValuedInterval {
    private static final long serialVersionUID = 8657984166944604756L;
    private String source;
    private String feature;
    private String frame;

    public GFFEntry(String chr, int start, int stop) {
        super(chr, start, stop);
    }

    public static GFFEntry parse(String line) {
        if (line.startsWith("#") || line.startsWith("track")) {
            return null;
        }
        String[] entry = line.split("\t");
        if (entry.length < 9) {
            throw new IntervalFileFormatException("Invalid GFF entry has < 9 columns");
        }
        String chr = entry[0];
        int start = Integer.parseInt(entry[3]);
        int stop = Integer.parseInt(entry[4]);
        String strand = entry[6];
        GFFEntry gff = new GFFEntry(chr, start, stop);
        gff.setSource(entry[1]);
        gff.setFeature(entry[2]);
        if (!entry[5].equals(".")) {
            gff.setValue(Double.valueOf(entry[5]));
        }
        gff.setFrame(entry[7]);
        String[] note = entry[8].split(";");
        String id = note[0].substring(9);
        gff.setId(id);
        int tmpLow = gff.low();
        int tmpHigh = gff.high();
        if (strand.equalsIgnoreCase("+")) {
            gff.setStart(tmpLow);
            gff.setStop(tmpHigh);
        } else if (strand.equalsIgnoreCase("-")) {
            gff.setStart(tmpHigh);
            gff.setStop(tmpLow);
        }
        return gff;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getFeature() {
        return this.feature;
    }

    public void setFeature(String feature) {
        this.feature = feature;
    }

    public String getFrame() {
        return this.frame;
    }

    public void setFrame(String frame) {
        this.frame = frame;
    }
}

