/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.io;

import edu.unc.genomics.BedEntry;
import edu.unc.genomics.io.IntervalFile;
import edu.unc.genomics.io.IntervalFileFormatException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.broad.igv.bbfile.BBFileReader;
import org.broad.igv.bbfile.BedFeature;

public class BigBedFile
extends IntervalFile<BedEntry> {
    BBFileReader reader;

    protected BigBedFile(Path p) throws IOException {
        super(p);
        this.reader = new BBFileReader(p.toString());
        if (!this.reader.isBigBedFile()) {
            throw new IntervalFileFormatException("Not a BigBed file!");
        }
    }

    @Override
    public int count() {
        return this.reader.getDataCount();
    }

    @Override
    public Set<String> chromosomes() {
        return new HashSet<String>(this.reader.getChromosomeNames());
    }

    @Override
    public Iterator<BedEntry> iterator() {
        return new BigBedEntryIterator((Iterator<BedFeature>)this.reader.getBigBedIterator());
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public Iterator<BedEntry> query(String chr, int start, int stop) throws UnsupportedOperationException {
        return new BigBedEntryIterator((Iterator<BedFeature>)this.reader.getBigBedIterator(chr, start, chr, stop, false));
    }

    private static class BigBedEntryIterator
    implements Iterator<BedEntry> {
        private final Iterator<BedFeature> it;

        public BigBedEntryIterator(Iterator<BedFeature> it) {
            this.it = it;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public BedEntry next() {
            BedFeature f = this.it.next();
            BedEntry bed = new BedEntry(f.getChromosome(), f.getStartBase(), f.getEndBase());
            String[] fields = f.getRestOfFields();
            if (fields.length > 0) {
                bed.setId(fields[0]);
            }
            if (fields.length > 1) {
                bed.setValue(Double.valueOf(fields[1]));
            }
            if (fields.length > 2 && fields[2].equalsIgnoreCase("-") && bed.isWatson()) {
                int tmp = bed.getStart();
                bed.setStart(bed.getStop());
                bed.setStop(tmp);
            }
            return bed;
        }

        @Override
        public void remove() {
            this.it.remove();
        }
    }
}

