/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.ngs;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.CommandLineTool;
import edu.unc.genomics.Interval;
import edu.unc.genomics.io.IntervalFile;
import edu.unc.genomics.io.WigFile;
import edu.unc.genomics.io.WigFileException;
import edu.unc.utils.FFTUtils;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class Autocorrelation
extends CommandLineTool {
    private static final Logger log = Logger.getLogger(Autocorrelation.class);
    @Parameter(names={"-i", "--input"}, description="Input file", required=true)
    public WigFile wig;
    @Parameter(names={"-l", "--loci"}, description="Genomic loci (Bed format)", required=true)
    public IntervalFile<? extends Interval> loci;
    @Parameter(names={"-o", "--output"}, description="Output file", required=true)
    public Path outputFile;
    @Parameter(names={"-m", "--max"}, description="Autocorrelation limit (bp)")
    public int limit = 200;

    @Override
    public void run() throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(this.outputFile, Charset.defaultCharset(), new OpenOption[0]);){
            log.debug((Object)"Computing autocorrelation for each window");
            int skipped = 0;
            for (Interval interval : this.loci) {
                Iterator wigIter;
                try {
                    wigIter = this.wig.query(interval);
                }
                catch (WigFileException | IOException e) {
                    log.debug((Object)("Skipping interval: " + interval.toString()));
                    ++skipped;
                    continue;
                }
                float[] data = WigFile.flattenData((Iterator)wigIter, (int)interval.getStart(), (int)interval.getStop());
                float[] auto = FFTUtils.autocorrelation(data, this.limit);
                writer.write(interval.toBed());
                for (int i = 0; i < auto.length; ++i) {
                    writer.write("\t" + auto[i]);
                }
                writer.newLine();
            }
            log.info((Object)("Skipped " + skipped + " intervals"));
        }
    }

    public static void main(String[] args) {
        new Autocorrelation().instanceMain(args);
    }
}

