/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.wigmath;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.io.WigFile;
import edu.unc.genomics.io.WigFileException;
import edu.unc.genomics.wigmath.WigMathTool;
import java.io.IOException;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class Scale
extends WigMathTool {
    private static final Logger log = Logger.getLogger(Scale.class);
    @Parameter(names={"-i", "--input"}, description="Input file", required=true)
    public WigFile inputFile;
    @Parameter(names={"-m", "--multiplier"}, description="Multiplier (scale factor, default = 1/mean)")
    public Double multiplier;

    @Override
    public void setup() {
        this.inputs.add(this.inputFile);
        if (this.multiplier == null || this.multiplier == 0.0) {
            this.multiplier = (double)this.inputFile.numBases() / this.inputFile.total();
            log.info((Object)("Scaling to mean: " + this.inputFile.mean()));
        }
    }

    @Override
    public float[] compute(String chr, int start, int stop) throws IOException, WigFileException {
        Iterator data = this.inputFile.query(chr, start, stop);
        float[] result = WigFile.flattenData((Iterator)data, (int)start, (int)stop);
        for (int i = 0; i < result.length; ++i) {
            result[i] = (float)(this.multiplier * (double)result[i]);
        }
        return result;
    }

    public static void main(String[] args) throws IOException, WigFileException {
        new Scale().instanceMain(args);
    }
}

