/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.io;

import edu.unc.genomics.Interval;
import edu.unc.genomics.io.BigWigFile;
import edu.unc.genomics.io.TextWigFile;
import edu.unc.genomics.io.WigFileException;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import org.apache.log4j.Logger;
import org.broad.igv.bbfile.WigItem;

public abstract class WigFile
implements Closeable {
    private static final Logger log = Logger.getLogger(WigFile.class);
    protected final Path p;

    protected WigFile(Path p) {
        log.debug((Object)("Initializing wig file: " + p.getFileName()));
        this.p = p;
    }

    public static WigFile autodetect(Path p) throws IOException, WigFileException {
        WigFile wig;
        if (BigWigFile.isBigWig(p)) {
            log.debug((Object)("Autodetected BigWig file type for: " + p.getFileName()));
            wig = new BigWigFile(p);
        } else {
            log.debug((Object)("Autodetected Wiggle file type for: " + p.getFileName()));
            wig = new TextWigFile(p);
        }
        return wig;
    }

    public static float[] flattenData(Iterator<WigItem> iter, int start, int stop, float defaultValue) {
        int low = Math.min(start, stop);
        int high = Math.max(start, stop);
        int length = high - low + 1;
        float[] data = new float[length];
        Arrays.fill(data, defaultValue);
        while (iter.hasNext()) {
            WigItem item = iter.next();
            for (int i = item.getStartBase(); i <= item.getEndBase(); ++i) {
                if (i < low || i > high) continue;
                data[i - low] = item.getWigValue();
            }
        }
        if (start > stop) {
            ArrayUtils.reverse((float[])data);
        }
        return data;
    }

    public static float[] flattenData(Iterator<WigItem> iter, int start, int stop) {
        return WigFile.flattenData(iter, start, stop, Float.NaN);
    }

    public static SummaryStatistics stats(Iterator<WigItem> iter, int start, int stop) {
        int low = Math.min(start, stop);
        int high = Math.max(start, stop);
        SummaryStatistics stats = new SummaryStatistics();
        while (iter.hasNext()) {
            WigItem item = iter.next();
            float value = item.getWigValue();
            if (Float.isNaN(value) || Float.isInfinite(value)) continue;
            for (int i = item.getStartBase(); i <= item.getEndBase(); ++i) {
                if (i < low || i > high) continue;
                stats.addValue((double)value);
            }
        }
        return stats;
    }

    public static float mean(Iterator<WigItem> iter, int start, int stop) {
        return (float)WigFile.stats(iter, start, stop).getMean();
    }

    public static float stdev(Iterator<WigItem> iter, int start, int stop) {
        return (float)Math.sqrt(WigFile.stats(iter, start, stop).getPopulationVariance());
    }

    public static float min(Iterator<WigItem> iter, int start, int stop) {
        return (float)WigFile.stats(iter, start, stop).getMin();
    }

    public static float max(Iterator<WigItem> iter, int start, int stop) {
        return (float)WigFile.stats(iter, start, stop).getMax();
    }

    public Path getPath() {
        return this.p;
    }

    public Iterator<WigItem> query(Interval i) throws IOException, WigFileException {
        return this.query(i.getChr(), i.low(), i.high());
    }

    public abstract Iterator<WigItem> query(String var1, int var2, int var3) throws IOException, WigFileException;

    public abstract Set<String> chromosomes();

    public abstract int getChrStart(String var1);

    public abstract int getChrStop(String var1);

    public boolean includes(Interval i) {
        return this.includes(i.getChr(), i.getStart(), i.getStop());
    }

    public abstract boolean includes(String var1, int var2, int var3);

    public abstract boolean includes(String var1);

    public abstract long numBases();

    public abstract double total();

    public abstract double mean();

    public abstract double stdev();

    public abstract double min();

    public abstract double max();

    public abstract String toString();
}

