/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.wigmath;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.io.WigFile;
import edu.unc.genomics.io.WigFileException;
import edu.unc.genomics.wigmath.WigMathTool;
import java.io.IOException;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class Shift
extends WigMathTool {
    private static final Logger log = Logger.getLogger(Shift.class);
    @Parameter(names={"-i", "--input"}, description="Input file", required=true)
    public WigFile inputFile;
    @Parameter(names={"-m", "--mean"}, description="New mean")
    public double newMean = 0.0;
    private double shift;

    @Override
    public void setup() {
        this.inputs.add(this.inputFile);
        this.shift = this.newMean - this.inputFile.mean();
        log.info((Object)("Shifting to mean: " + this.newMean));
    }

    @Override
    public float[] compute(String chr, int start, int stop) throws IOException, WigFileException {
        Iterator data = this.inputFile.query(chr, start, stop);
        float[] result = WigFile.flattenData((Iterator)data, (int)start, (int)stop);
        int i = 0;
        while (i < result.length) {
            int n = i++;
            result[n] = (float)((double)result[n] + this.shift);
        }
        return result;
    }

    public static void main(String[] args) throws IOException, WigFileException {
        new Shift().instanceMain(args);
    }
}

