/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.index;

import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntIterators;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import it.unimi.dsi.fastutil.objects.ReferenceSets;
import it.unimi.dsi.mg4j.document.PropertyBasedDocumentFactory;
import it.unimi.dsi.mg4j.index.DiskBasedIndex;
import it.unimi.dsi.mg4j.index.FileIndex;
import it.unimi.dsi.mg4j.index.IndexIterator;
import it.unimi.dsi.mg4j.index.IndexReader;
import it.unimi.dsi.mg4j.index.TermProcessor;
import it.unimi.dsi.mg4j.index.TooManyTermsException;
import it.unimi.dsi.mg4j.index.cluster.IndexCluster;
import it.unimi.dsi.mg4j.index.payload.Payload;
import it.unimi.dsi.mg4j.index.remote.IndexServer;
import it.unimi.dsi.mg4j.search.IntervalIterator;
import it.unimi.dsi.mg4j.search.visitor.DocumentIteratorVisitor;
import it.unimi.dsi.mg4j.util.Fast;
import it.unimi.dsi.mg4j.util.Properties;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.EnumMap;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.log4j.Logger;

public abstract class Index
implements Serializable {
    private static final Logger LOGGER = Fast.getLogger(Index.class);
    private static final long serialVersionUID = 0L;
    public final String field;
    public final Properties properties;
    public final int numberOfDocuments;
    public final int numberOfTerms;
    public final long numberOfOccurrences;
    public final long numberOfPostings;
    public final int maxCount;
    public final Payload payload;
    public final boolean hasPayloads;
    public final boolean hasCounts;
    public final boolean hasPositions;
    public final TermProcessor termProcessor;
    public ReferenceSet<Index> singletonSet;
    public Index keyIndex;
    public final IntList sizes;
    public final EmptyIndexIterator emptyIndexIterator = new EmptyIndexIterator();

    protected Index(int numberOfDocuments, int numberOfTerms, long numberOfPostings, long numberOfOccurrences, int maxCount, Payload payload, boolean hasCounts, boolean hasPositions, TermProcessor termProcessor, String field, IntList sizes, Properties properties) {
        this.numberOfDocuments = numberOfDocuments;
        this.numberOfTerms = numberOfTerms;
        this.numberOfPostings = numberOfPostings;
        this.numberOfOccurrences = numberOfOccurrences;
        this.maxCount = maxCount;
        this.payload = payload;
        this.hasPayloads = payload != null;
        this.hasCounts = hasCounts;
        this.hasPositions = hasPositions;
        this.termProcessor = termProcessor;
        this.field = field;
        this.properties = properties;
        this.keyIndex = this;
        this.singletonSet = ReferenceSets.singleton((Object)this);
        this.sizes = sizes;
    }

    protected static TermProcessor getTermProcessor(Properties properties) {
        try {
            if (properties.getProperty(PropertyKeys.TERMPROCESSOR) == null) {
                throw new IllegalArgumentException("No term processor has been specified (most likely, because of an obsolete property file)");
            }
            Class<?> termProcessorClass = Class.forName(properties.getString(PropertyKeys.TERMPROCESSOR));
            return (TermProcessor)termProcessorClass.getMethod("getInstance", null).invoke(termProcessorClass, (Object[])null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Index getInstance(CharSequence uri, boolean randomAccess, boolean documentSizes, boolean maps) throws IOException, ConfigurationException, URISyntaxException, ClassNotFoundException, SecurityException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Class<?> indexClass;
        String className;
        String query;
        String basename;
        String uriString = ((Object)uri).toString();
        if (uriString.startsWith("mg4j:")) {
            URI u = new URI(uriString);
            return IndexServer.getIndex(u.getHost(), u.getPort(), randomAccess, documentSizes);
        }
        if (uriString.startsWith("file:")) {
            URI u = new URI(uriString);
            basename = u.getPath();
            query = u.getQuery();
        } else {
            int questionMarkPos = uriString.indexOf(63);
            basename = questionMarkPos == -1 ? uriString : uriString.substring(0, questionMarkPos);
            query = questionMarkPos == -1 ? null : uriString.substring(questionMarkPos + 1);
        }
        LOGGER.debug((Object)("Searching for an index with basename " + basename + "..."));
        Properties properties = new Properties(basename + ".properties");
        LOGGER.debug((Object)("Properties: " + properties));
        EnumMap<UriKeys, String> queryProperties = new EnumMap<UriKeys, String>(UriKeys.class);
        if (query != null) {
            String[] keyValue = query.split(";");
            for (int i = 0; i < keyValue.length; ++i) {
                String[] piece = keyValue[i].split("=");
                if (piece.length != 2) {
                    throw new IllegalArgumentException("Malformed key/value pair: " + keyValue[i]);
                }
                boolean found = false;
                for (UriKeys key : UriKeys.values()) {
                    found = PropertyBasedDocumentFactory.sameKey(key, piece[0]);
                    if (!found) continue;
                    queryProperties.put(key, piece[1]);
                    break;
                }
                if (found) continue;
                throw new IllegalArgumentException("Unknown key: " + piece[0]);
            }
        }
        if ("it.unimi.dsi.mg4j.index.SkipFileIndex".equals(className = properties.getString(PropertyKeys.INDEXCLASS, "(missing index class)"))) {
            className = FileIndex.class.getName();
        }
        if (IndexCluster.class.isAssignableFrom(indexClass = Class.forName(className))) {
            return IndexCluster.getInstance((CharSequence)basename, randomAccess, documentSizes, queryProperties);
        }
        return DiskBasedIndex.getInstance(basename, properties, randomAccess, documentSizes, maps, queryProperties);
    }

    public static Index getInstance(CharSequence uri, boolean randomAccess, boolean documentSizes) throws IOException, ConfigurationException, URISyntaxException, ClassNotFoundException, SecurityException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return Index.getInstance(uri, randomAccess, documentSizes, true);
    }

    public static Index getInstance(CharSequence uri, boolean randomAccess) throws ConfigurationException, IOException, URISyntaxException, ClassNotFoundException, SecurityException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return Index.getInstance(uri, randomAccess, false);
    }

    public static Index getInstance(CharSequence uri) throws ConfigurationException, IOException, URISyntaxException, ClassNotFoundException, SecurityException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return Index.getInstance(uri, true);
    }

    public IndexReader getReader() throws IOException {
        return this.getReader(-1);
    }

    public abstract IndexReader getReader(int var1) throws IOException;

    public IndexIterator documents(int term) throws IOException {
        IndexReader indexReader = this.getReader();
        IndexIterator indexIterator = indexReader.documents(term);
        if (indexIterator == this.emptyIndexIterator) {
            indexReader.close();
        }
        return indexIterator;
    }

    public IndexIterator documents(CharSequence term) throws IOException {
        IndexReader indexReader = this.getReader();
        IndexIterator indexIterator = indexReader.documents(term);
        if (indexIterator == this.emptyIndexIterator) {
            indexReader.close();
        }
        return indexIterator;
    }

    public abstract IndexIterator documents(CharSequence var1, int var2) throws IOException, TooManyTermsException;

    public void keyIndex(Index newKeyIndex) {
        this.keyIndex = newKeyIndex;
        this.singletonSet = ReferenceSets.singleton((Object)this.keyIndex);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class EmptyIndexIterator
    extends IntIterators.EmptyIterator
    implements IndexIterator,
    Serializable {
        private static final long serialVersionUID = 0L;

        protected EmptyIndexIterator() {
        }

        @Override
        public int document() {
            throw new IllegalStateException();
        }

        @Override
        public ReferenceSet<Index> indices() {
            return Index.this.singletonSet;
        }

        @Override
        public IntervalIterator intervalIterator() {
            throw new IllegalStateException();
        }

        @Override
        public Reference2ReferenceMap<Index, IntervalIterator> intervalIterators() {
            throw new IllegalStateException();
        }

        @Override
        public IntervalIterator intervalIterator(Index index) {
            throw new IllegalStateException();
        }

        @Override
        public int nextDocument() {
            return -1;
        }

        @Override
        public int skipTo(int n) {
            return Integer.MAX_VALUE;
        }

        @Override
        public int frequency() {
            return 0;
        }

        @Override
        public Payload payload() {
            throw new IllegalStateException();
        }

        @Override
        public int count() {
            throw new IllegalStateException();
        }

        @Override
        public IntIterator positions() {
            throw new IllegalStateException();
        }

        @Override
        public int positions(int[] positions) {
            throw new IllegalStateException();
        }

        @Override
        public int[] positionArray() {
            throw new IllegalStateException();
        }

        @Override
        public void dispose() {
        }

        @Override
        public Index index() {
            return Index.this;
        }

        @Override
        public boolean accept(DocumentIteratorVisitor visitor) {
            return true;
        }

        @Override
        public boolean acceptOnTruePaths(DocumentIteratorVisitor visitor) {
            throw new IllegalStateException();
        }

        @Override
        public String term() {
            return null;
        }

        @Override
        public void term(CharSequence term) {
        }

        @Override
        public int id() {
            return -1;
        }

        @Override
        public void id(int id) {
        }

        @Override
        public IntervalIterator iterator() {
            return this.intervalIterator();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UriKeys {
        INMEMORY,
        MAPPED,
        OFFSETSTEP,
        SIZES;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PropertyKeys {
        DOCUMENTS,
        TERMS,
        OCCURRENCES,
        POSTINGS,
        BATCHES,
        MAXCOUNT,
        MAXDOCSIZE,
        TERMPROCESSOR,
        PAYLOADCLASS,
        CODING,
        INDEXCLASS,
        FIELD,
        SIZE;

    }
}

