/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.search;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.objects.ReferenceArraySet;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import it.unimi.dsi.mg4j.index.Index;
import it.unimi.dsi.mg4j.index.IndexIterator;
import it.unimi.dsi.mg4j.search.AbstractDocumentIterator;
import it.unimi.dsi.mg4j.search.DocumentIterator;
import it.unimi.dsi.mg4j.search.Interval;
import it.unimi.dsi.mg4j.search.IntervalIterator;
import it.unimi.dsi.mg4j.search.visitor.DocumentIteratorVisitor;
import it.unimi.dsi.mg4j.util.MutableString;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCompositeDocumentIterator
extends AbstractDocumentIterator
implements DocumentIterator {
    protected final DocumentIterator[] documentIterator;
    protected final int n;
    protected final IndexIterator[] indexIterator;
    protected final ReferenceArraySet<Index> indices = new ReferenceArraySet();
    protected final Index soleIndex;

    public AbstractCompositeDocumentIterator(DocumentIterator ... documentIterator) {
        this.documentIterator = documentIterator;
        int i = this.n = documentIterator.length;
        while (i-- != 0) {
            this.indices.addAll(documentIterator[i].indices());
        }
        this.soleIndex = this.indices.size() == 1 ? (Index)this.indices.iterator().next() : null;
        i = this.n;
        while (i-- != 0 && documentIterator[i] instanceof IndexIterator) {
        }
        if (i == -1) {
            this.indexIterator = new IndexIterator[this.n];
            System.arraycopy(documentIterator, 0, this.indexIterator, 0, this.n);
        } else {
            this.indexIterator = null;
        }
    }

    @Override
    public boolean accept(DocumentIteratorVisitor visitor) throws IOException {
        if (!visitor.visitPre(this)) {
            return false;
        }
        for (int i = 0; i < this.n; ++i) {
            if (this.documentIterator[i] == null || this.documentIterator[i].accept(visitor)) continue;
            return false;
        }
        return visitor.visitPost(this);
    }

    @Override
    public boolean acceptOnTruePaths(DocumentIteratorVisitor visitor) throws IOException {
        if (!visitor.visitPre(this)) {
            return false;
        }
        for (int i = 0; i < this.n; ++i) {
            if (this.documentIterator[i] == null || this.documentIterator[i].acceptOnTruePaths(visitor)) continue;
            return false;
        }
        return visitor.visitPost(this);
    }

    @Override
    public ReferenceSet<Index> indices() {
        return this.indices;
    }

    @Override
    public IntervalIterator intervalIterator() throws IOException {
        if (this.soleIndex == null) {
            throw new IllegalStateException();
        }
        return this.intervalIterator(this.soleIndex);
    }

    @Override
    public void dispose() throws IOException {
        int i = this.n;
        while (i-- != 0) {
            this.documentIterator[i].dispose();
        }
    }

    public String toString() {
        StringBuilder res = new StringBuilder();
        res.append(this.getClass().getSimpleName()).append("(");
        for (int i = 0; i < this.n; ++i) {
            res.append(i > 0 ? "," : "").append(this.documentIterator[i]);
        }
        return res.append(")").toString();
    }

    protected static abstract class AbstractCompositeIndexIntervalIterator
    extends AbstractDocumentIterator.AbstractIntervalIterator {
        protected int[][] position;
        protected int[] currPos;
        protected int[] curr;
        protected int[] count;

        public AbstractCompositeIndexIntervalIterator(int n) {
            this.position = new int[n][];
            this.count = new int[n];
            this.currPos = new int[n];
            this.curr = new int[n];
        }

        public String toString() {
            MutableString res = new MutableString();
            res.append(this.getClass().getName()).append("(").delete(0, res.lastIndexOf('.') + 1);
            for (int i = 0; i < this.position.length; ++i) {
                res.append(i > 0 ? "," : "").append(IntArrayList.wrap((int[])this.position[i], (int)this.count[i]));
            }
            return res.append(")").toString();
        }
    }

    protected static abstract class AbstractCompositeIntervalIterator
    extends AbstractDocumentIterator.AbstractIntervalIterator {
        protected IntervalIterator[] intervalIterator;
        protected Interval[] curr;

        public AbstractCompositeIntervalIterator(int n) {
            this.curr = new Interval[n];
            this.intervalIterator = new IntervalIterator[n];
        }

        public String toString() {
            MutableString res = new MutableString();
            res.append(this.getClass().getName()).append("(").delete(0, res.lastIndexOf('.') + 1);
            for (int i = 0; i < this.intervalIterator.length; ++i) {
                res.append(i > 0 ? "," : "").append(this.intervalIterator[i]);
            }
            return res.append(")").toString();
        }
    }
}

