/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.search.score;

import it.unimi.dsi.fastutil.objects.Reference2DoubleMap;
import it.unimi.dsi.mg4j.index.Index;
import it.unimi.dsi.mg4j.search.Interval;
import it.unimi.dsi.mg4j.search.IntervalIterator;
import it.unimi.dsi.mg4j.search.IntervalIterators;
import it.unimi.dsi.mg4j.search.score.AbstractWeightedScorer;
import it.unimi.dsi.mg4j.search.score.DelegatingScorer;
import java.io.IOException;

public class ClarkeCormackScorer
extends AbstractWeightedScorer
implements DelegatingScorer {
    public static final int DEFAULT_H = 16;
    public final int h;
    public final double alpha;
    public final boolean normalize;

    public ClarkeCormackScorer(int h, double alpha, boolean normalize) {
        this.h = h;
        this.alpha = alpha;
        this.normalize = normalize;
    }

    public ClarkeCormackScorer(String h, String alpha, String normalize) {
        this(Integer.parseInt(h), Double.parseDouble(alpha), Boolean.parseBoolean(normalize));
    }

    public ClarkeCormackScorer() {
        this(16, 1.0, true);
    }

    public synchronized ClarkeCormackScorer copy() {
        ClarkeCormackScorer scorer = new ClarkeCormackScorer(this.h, this.alpha, this.normalize);
        scorer.setWeights((Reference2DoubleMap<Index>)this.index2Weight);
        return scorer;
    }

    public double score(Index index) throws IOException {
        Interval interval;
        IntervalIterator it = this.documentIterator.intervalIterator(index);
        if (it == IntervalIterators.TRUE || it == IntervalIterators.FALSE) {
            return 0.0;
        }
        double result = 0.0;
        int count = 0;
        while ((interval = it.nextInterval()) != null) {
            ++count;
            int lt = interval.length();
            if (lt < this.h) {
                result += 1.0;
                continue;
            }
            result += Math.pow((double)this.h / (double)lt, this.alpha);
        }
        return this.normalize ? result / (double)count : result;
    }

    public String toString() {
        return "Clarke-Cormack(" + this.h + ", " + this.alpha + ", " + this.normalize + ')';
    }

    public boolean usesIntervals() {
        return true;
    }
}

