/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.search.score;

import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.mg4j.index.Index;
import it.unimi.dsi.mg4j.search.DocumentIterator;
import it.unimi.dsi.mg4j.search.score.AbstractScorer;
import it.unimi.dsi.mg4j.search.score.DelegatingScorer;
import java.io.IOException;

public class DecreasingDocumentRankScorer
extends AbstractScorer
implements DelegatingScorer {
    private double[] score;
    private double first;
    private double latest;

    public DecreasingDocumentRankScorer(String filename) throws IOException {
        this(BinIO.loadDoubles((CharSequence)filename));
    }

    public DecreasingDocumentRankScorer(double[] score) {
        this.score = score;
    }

    public DecreasingDocumentRankScorer copy() {
        return new DecreasingDocumentRankScorer(this.score);
    }

    public double score() {
        int current = this.documentIterator.document();
        if (this.first == Double.MAX_VALUE) {
            this.first = this.score[current];
            if (this.first == 0.0) {
                this.first = 1.0;
            }
        } else if (this.score[current] > this.latest) {
            throw new IllegalStateException();
        }
        this.latest = this.score[current];
        return this.latest / this.first;
    }

    public double score(Index index) {
        throw new UnsupportedOperationException();
    }

    public void wrap(DocumentIterator documentIterator) throws IOException {
        super.wrap(documentIterator);
        this.first = Double.MAX_VALUE;
    }

    public String toString() {
        return "DecreasingDocumentRank";
    }

    public boolean usesIntervals() {
        return false;
    }
}

