/*
 * Decompiled with CFR 0.152.
 */
package test.it.unimi.dsi.mg4j.util;

import it.unimi.dsi.mg4j.util.Fast;
import junit.framework.TestCase;

public class FastTest
extends TestCase {
    public static final double[] GOLOMB_STEP = new double[]{0.3819660112501052, 0.245122333753307, 0.1808274866038356, 0.1433251161454971, 0.1187285383664304, 0.1013462873713007, 0.0884076465179451, 0.078400680366017, 0.0704298717679771, 0.0639308889222416, 0.0585303826783648, 0.0539714717143864, 0.0500716000363801, 0.0466974625983358, 0.0437494423620109};
    public static final int GOLOMB_STEP_LENGTH = GOLOMB_STEP.length;
    public static final double GOLOMB_THRESHOLD = 0.0411515989924386;
    public static final double GOLOMB_ADD = -(1.0 + Math.log(2.0)) / 2.0;
    public static final double GOLOMB_MULT = Math.log(2.0);
    protected static final double GOLOMB_GAUSSIAN = 2.0 * Math.sqrt(0.6366197723675814) * Math.log(2.0);

    public void testInt2Nat() {
        int i;
        FastTest.assertEquals((int)Integer.MAX_VALUE, (int)Fast.int2nat(-1073741824));
        FastTest.assertEquals((int)0x7FFFFFFD, (int)Fast.int2nat(-1073741823));
        FastTest.assertEquals((int)0x7FFFFFFE, (int)Fast.int2nat(0x3FFFFFFF));
        for (i = 0; i < 16; ++i) {
            FastTest.assertEquals((int)(2 * i), (int)Fast.int2nat(i));
        }
        for (i = -16; i < 0; ++i) {
            FastTest.assertEquals((int)(-2 * i - 1), (int)Fast.int2nat(i));
        }
        FastTest.assertEquals((long)Long.MAX_VALUE, (long)Fast.int2nat(-4611686018427387904L));
        FastTest.assertEquals((long)0x7FFFFFFFFFFFFFFDL, (long)Fast.int2nat(-4611686018427387903L));
        FastTest.assertEquals((long)0x7FFFFFFFFFFFFFFEL, (long)Fast.int2nat(0x3FFFFFFFFFFFFFFFL));
        for (i = 0; i < 16; ++i) {
            FastTest.assertEquals((long)(2L * (long)i), (long)Fast.int2nat(i));
        }
        for (i = -16; i < 0; ++i) {
            FastTest.assertEquals((long)(-2L * (long)i - 1L), (long)Fast.int2nat(i));
        }
    }

    public void testNat2Int() {
        int i;
        FastTest.assertEquals((int)-1073741824, (int)Fast.nat2int(Integer.MAX_VALUE));
        FastTest.assertEquals((int)-1073741823, (int)Fast.nat2int(0x7FFFFFFD));
        FastTest.assertEquals((int)0x3FFFFFFF, (int)Fast.nat2int(0x7FFFFFFE));
        for (i = 0; i < 16; ++i) {
            FastTest.assertEquals((int)i, (int)Fast.nat2int(2 * i));
        }
        for (i = -16; i < 0; ++i) {
            FastTest.assertEquals((int)i, (int)Fast.nat2int(-2 * i - 1));
        }
        FastTest.assertEquals((long)-4611686018427387903L, (long)Fast.nat2int(0x7FFFFFFFFFFFFFFDL));
        FastTest.assertEquals((long)-4611686018427387904L, (long)Fast.nat2int(Long.MAX_VALUE));
        FastTest.assertEquals((long)0x3FFFFFFFFFFFFFFFL, (long)Fast.nat2int(0x7FFFFFFFFFFFFFFEL));
        for (i = 0; i < 16; ++i) {
            FastTest.assertEquals((long)i, (long)Fast.nat2int(2L * (long)i));
        }
        for (i = -16; i < 0; ++i) {
            FastTest.assertEquals((long)i, (long)Fast.nat2int(-2L * (long)i - 1L));
        }
    }

    public static int golombModulus(double p) {
        if (p < 0.0411515989924386) {
            return (int)Math.ceil(GOLOMB_ADD + GOLOMB_MULT / p);
        }
        int i = GOLOMB_STEP_LENGTH;
        while (i-- != 0) {
            if (!(p < GOLOMB_STEP[i])) continue;
            return i + 2;
        }
        return 1;
    }

    public void testGolomb() {
        for (int p = 1; p < 1000; ++p) {
            for (int q = p + 1; q < 1000; ++q) {
                FastTest.assertEquals((String)("p/q=" + p + "/" + q), (int)FastTest.golombModulus((double)p / (double)q), (int)Fast.golombModulus(p, q));
            }
        }
    }

    public static int gaussianGolombModulus(double sigma) {
        return (int)Math.ceil(GOLOMB_GAUSSIAN * sigma);
    }

    public void testGaussianGolomb() {
        for (int quantum = 1; quantum <= 64; ++quantum) {
            for (int p = 1; p < 100; ++p) {
                for (int q = p; q < 100000; q *= 2) {
                    for (int i = 0; i < 20; ++i) {
                        double relativeFrequency = (double)p / (double)q;
                        FastTest.assertEquals((String)("p/q=" + p + "/" + q + ", quantum=" + quantum + ", i=" + i), (double)(Math.sqrt((double)quantum * (1.0 - relativeFrequency)) / relativeFrequency), (double)((double)Fast.quantumSigma(p, q, quantum) / 2.147483648E9), (double)1.0E-4);
                        FastTest.assertEquals((String)("p/q=" + p + "/" + q + ", quantum=" + quantum + ", i=" + i), (double)FastTest.gaussianGolombModulus(Math.sqrt((double)quantum * (1.0 - relativeFrequency)) / relativeFrequency * Math.sqrt((double)(1 << i) / 2.0)), (double)Fast.gaussianGolombModulus(Fast.quantumSigma(p, q, quantum), i), (double)Math.max((double)Fast.gaussianGolombModulus(Fast.quantumSigma(p, q, quantum), i) * 0.001, 1.0));
                    }
                }
            }
        }
    }

    public void testFormatBinarySize() {
        FastTest.assertEquals((String)"1", (String)Fast.formatBinarySize(1L));
        FastTest.assertEquals((String)"2", (String)Fast.formatBinarySize(2L));
        boolean ok = false;
        try {
            Fast.formatBinarySize(6L);
        }
        catch (IllegalArgumentException e) {
            ok = true;
        }
        FastTest.assertTrue((boolean)ok);
        FastTest.assertEquals((String)"128", (String)Fast.formatBinarySize(128L));
        FastTest.assertEquals((String)"1Ki", (String)Fast.formatBinarySize(1024L));
        FastTest.assertEquals((String)"2Ki", (String)Fast.formatBinarySize(2048L));
        FastTest.assertEquals((String)"1Mi", (String)Fast.formatBinarySize(0x100000L));
        FastTest.assertEquals((String)"2Mi", (String)Fast.formatBinarySize(0x200000L));
        FastTest.assertEquals((String)"1Gi", (String)Fast.formatBinarySize(0x40000000L));
        FastTest.assertEquals((String)"2Gi", (String)Fast.formatBinarySize(0x80000000L));
        FastTest.assertEquals((String)"1Ti", (String)Fast.formatBinarySize(0x10000000000L));
        FastTest.assertEquals((String)"2Ti", (String)Fast.formatBinarySize(0x20000000000L));
    }

    public void testFormatSize() {
        FastTest.assertEquals((String)"1", (String)Fast.formatSize(1L));
        FastTest.assertEquals((String)"2", (String)Fast.formatSize(2L));
        FastTest.assertEquals((String)"128", (String)Fast.formatSize(128L));
        FastTest.assertEquals((String)"1.00K", (String)Fast.formatSize(1000L));
        FastTest.assertEquals((String)"2.00K", (String)Fast.formatSize(2000L));
        FastTest.assertEquals((String)"2.50K", (String)Fast.formatSize(2500L));
        FastTest.assertEquals((String)"1.00M", (String)Fast.formatSize(1000000L));
        FastTest.assertEquals((String)"2.00M", (String)Fast.formatSize(2000000L));
        FastTest.assertEquals((String)"1.00G", (String)Fast.formatSize(1000000000L));
        FastTest.assertEquals((String)"2.00G", (String)Fast.formatSize(2000000000L));
        FastTest.assertEquals((String)"1.00T", (String)Fast.formatSize(1000000000000L));
        FastTest.assertEquals((String)"2.00T", (String)Fast.formatSize(2000000000000L));
    }

    public void testLeastMostSignificantBit() {
        int i;
        for (i = 0; i < 32; ++i) {
            FastTest.assertEquals((int)i, (int)Fast.leastSignificantBit(1 << i));
            FastTest.assertEquals((int)i, (int)Fast.mostSignificantBit(1 << i));
            FastTest.assertEquals((int)0, (int)Fast.leastSignificantBit(1 << i | 1));
            FastTest.assertEquals((int)i, (int)Fast.mostSignificantBit(1 << i | 1));
            FastTest.assertEquals((int)i, (int)Fast.leastSignificantBit(1L << i));
            FastTest.assertEquals((int)i, (int)Fast.mostSignificantBit(1L << i));
            FastTest.assertEquals((int)0, (int)Fast.leastSignificantBit(1L << i | 1L));
            FastTest.assertEquals((int)i, (int)Fast.mostSignificantBit(1L << i | 1L));
        }
        for (i = 32; i < 64; ++i) {
            FastTest.assertEquals((int)i, (int)Fast.leastSignificantBit(1L << i));
            FastTest.assertEquals((int)i, (int)Fast.mostSignificantBit(1L << i));
            FastTest.assertEquals((int)0, (int)Fast.leastSignificantBit(1L << i | 1L));
            FastTest.assertEquals((int)i, (int)Fast.mostSignificantBit(1L << i | 1L));
        }
    }
}

