/*
 * Decompiled with CFR 0.152.
 */
package test.it.unimi.dsi.mg4j.util.parser.callback;

import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.Reference2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.mg4j.util.MutableString;
import it.unimi.dsi.mg4j.util.parser.BulletParser;
import it.unimi.dsi.mg4j.util.parser.callback.AnchorExtractor;
import junit.framework.TestCase;

public class AnchorExtractorTest
extends TestCase {
    private static String[] sampleDocuments = new String[]{"<HTML>This is an example with some context <A href=\"example0.pdf\">an anchor</a> and something afterwards", "<HTML>This is an example with some context <A href=\"example1.pdf\">an anchor but nothing afterwards</a>", "<HTML><A href=\"example2.pdf\">This is an example with nothing before, an anchor</a> and something afterwards", "<HTML>This is an example with some context <A href=\"example3.pdf\"></a> no anchor, and something afterwards", "<HTML><A href=\"example4.pdf\"></a> nothing before, no anchor, and something afterwards", "<HTML>No anchor, nothing after <A href=\"example5.pdf\"></a>", "<HTML><A href=\"example6.pdf\"></a>", "<HTML>Here are <a href=\"example7a.pdf\">many anchors</a><a href=\"example7b.pdf\">with no</a><a href=\"example7c.pdf\">context after them</a><a href=\"example7d.pdf\">except for</a> the last one", "<HTML>Here are <a href=\"example8a.pdf\">many anchors</a> aa <a href=\"example8b.pdf\">slight overlap</a> bb <a href=\"example8c.pdf\">their context</a> cc <a href=\"example8d.pdf\">just reeeally</a> dd ", "<HTML>Here are <a href=\"example9a.pdf\">many anchors</a> aa xx yy and why why why<a href=\"example9b.pdf\">slight overlap</a> bb ww zz<a href=\"example9c.pdf\">their context</a> cc uu vv<a href=\"example9d.pdf\">just reeeally</a> dd ss tt"};
    private static String[][] expectedAnchorTextsWithContext = new String[][]{{"context an anchor and"}, {"context an anchor but"}, {"This is an  and"}, {"context  no"}, {""}, {"after"}, {""}, {"are many anchors", "with no", "context after", "except for the"}, {"are many anchors aa", "aa slight overlap bb", "bb their context cc", "cc just reeeally dd"}, {"are many anchors aa", "why whyslight overlap bb", "bb ww zztheir context cc", "cc uu vvjust reeeally dd"}};
    private static Reference2ObjectMap<MutableString, MutableString>[] expectedResWithContext = new Reference2ObjectMap[expectedAnchorTextsWithContext.length];

    public void testExtractorWithContext() {
        BulletParser parser = new BulletParser();
        AnchorExtractor extractor = new AnchorExtractor(10, 15, 5);
        parser.setCallback(extractor);
        for (int i = 0; i < sampleDocuments.length; ++i) {
            parser.parse(sampleDocuments[i].toCharArray());
            System.out.println(extractor.anchors);
            AnchorExtractorTest.assertEquals((int)expectedResWithContext[i].size(), (int)extractor.anchors.size());
            ObjectIterator expectedKeyIterator = expectedResWithContext[i].keySet().iterator();
            int k = 0;
            while (expectedKeyIterator.hasNext()) {
                MutableString expectedKey = (MutableString)expectedKeyIterator.next();
                MutableString expectedValue = (MutableString)expectedResWithContext[i].get((Object)expectedKey);
                AnchorExtractorTest.assertEquals((Object)expectedKey, (Object)((AnchorExtractor.Anchor)extractor.anchors.get(k)).documentSpecifier());
                AnchorExtractorTest.assertEquals((Object)expectedValue, (Object)((AnchorExtractor.Anchor)extractor.anchors.get(k)).text().trim());
                ++k;
            }
            AnchorExtractorTest.assertEquals((int)k, (int)extractor.anchors.size());
        }
    }

    static {
        for (int i = 0; i < expectedAnchorTextsWithContext.length; ++i) {
            AnchorExtractorTest.expectedResWithContext[i] = new Reference2ObjectLinkedOpenHashMap();
            if (expectedAnchorTextsWithContext[i].length == 1) {
                expectedResWithContext[i].put((Object)new MutableString("example" + i + ".pdf"), (Object)new MutableString(expectedAnchorTextsWithContext[i][0]));
                continue;
            }
            for (int j = 0; j < expectedAnchorTextsWithContext[i].length; ++j) {
                expectedResWithContext[i].put((Object)new MutableString("example" + i + (char)(97 + j) + ".pdf"), (Object)new MutableString(expectedAnchorTextsWithContext[i][j]));
            }
        }
    }
}

