/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.index.cluster;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.mg4j.index.Index;
import it.unimi.dsi.mg4j.index.IndexIterator;
import it.unimi.dsi.mg4j.index.IndexIterators;
import it.unimi.dsi.mg4j.index.TermProcessor;
import it.unimi.dsi.mg4j.index.TooManyTermsException;
import it.unimi.dsi.mg4j.index.cluster.DocumentalClusterIndexReader;
import it.unimi.dsi.mg4j.index.cluster.DocumentalClusteringStrategy;
import it.unimi.dsi.mg4j.index.cluster.DocumentalConcatenatedCluster;
import it.unimi.dsi.mg4j.index.cluster.DocumentalConcatenatedClusterIndexIterator;
import it.unimi.dsi.mg4j.index.cluster.DocumentalMergedClusterIndexIterator;
import it.unimi.dsi.mg4j.index.cluster.IndexCluster;
import it.unimi.dsi.mg4j.index.payload.Payload;
import it.unimi.dsi.mg4j.search.AbstractDocumentIterator;
import it.unimi.dsi.mg4j.util.BloomFilter;
import it.unimi.dsi.mg4j.util.Properties;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang.ClassUtils;

public abstract class DocumentalCluster
extends IndexCluster {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    public final boolean concatenated;
    public final boolean flat;
    public final int[] allIndices;
    protected final DocumentalClusteringStrategy strategy;

    public DocumentalCluster(Index[] localIndex, DocumentalClusteringStrategy strategy, boolean flat, BloomFilter[] termFilter, int numberOfDocuments, int numberOfTerms, long numberOfPostings, long numberOfOccurences, int maxCount, Payload payload, boolean hasCounts, boolean hasPositions, TermProcessor termProcessor, String field, IntList sizes, Properties properties) {
        super(localIndex, termFilter, numberOfDocuments, numberOfTerms, numberOfPostings, numberOfOccurences, maxCount, payload, hasCounts, hasPositions, termProcessor, field, sizes, properties);
        this.strategy = strategy;
        this.flat = flat;
        this.concatenated = this.getClass().isAssignableFrom(DocumentalConcatenatedCluster.class);
        this.allIndices = new int[localIndex.length];
        int i = this.allIndices.length;
        while (i-- != 0) {
            this.allIndices[i] = i;
        }
    }

    public DocumentalClusterIndexReader getReader(int bufferSize) throws IOException {
        return new DocumentalClusterIndexReader(this, bufferSize == -1 ? 8192 : bufferSize);
    }

    public IndexIterator documents(CharSequence prefix, int limit) throws IOException, TooManyTermsException {
        ArrayList<IndexIterator> iterators = new ArrayList<IndexIterator>(this.localIndex.length);
        IntArrayList usedIndices = new IntArrayList();
        for (int i = 0; i < this.localIndex.length; ++i) {
            IndexIterator documentIterator = this.localIndex[i].documents(prefix, limit);
            if (!documentIterator.hasNext()) continue;
            iterators.add(documentIterator);
            usedIndices.add(i);
        }
        AbstractDocumentIterator result = this.concatenated ? new DocumentalConcatenatedClusterIndexIterator((DocumentalClusterIndexReader)this.getReader(), iterators.toArray(IndexIterators.EMPTY_ARRAY), usedIndices.toIntArray()) : new DocumentalMergedClusterIndexIterator((DocumentalClusterIndexReader)this.getReader(), iterators.toArray(IndexIterators.EMPTY_ARRAY), usedIndices.toIntArray());
        result.term(prefix);
        return result;
    }

    public String toString() {
        return ClassUtils.getShortClassName((Object)this, null) + Arrays.toString(this.localIndex);
    }
}

