/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.test;

import cern.colt.Timer;
import it.unimi.dsi.mg4j.test.StringBuffer2;
import it.unimi.dsi.mg4j.util.MutableString;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class MutableStringReplaceSpeedTest {
    private MutableStringReplaceSpeedTest() {
    }

    public static void main(String[] arg) {
        MutableString s;
        String target = null;
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            MutableString ms = new MutableString();
            while ((line = br.readLine()) != null) {
                ms.append("\n").append(line);
            }
            target = ms.toString();
        }
        catch (IOException e) {
            System.err.println("Problems while reading target");
            e.printStackTrace(System.err);
            System.exit(1);
        }
        int n = Integer.parseInt(arg[0]);
        MutableString amp = new MutableString("&amp;");
        Timer timer = new Timer();
        int k = 10;
        while (k-- != 0) {
            s = new MutableString(target);
            timer.reset();
            timer.start();
            int i = n;
            while (i-- != 0) {
                s.replace('&', amp);
            }
            timer.stop();
            System.err.println("Called replace() " + n + " times on a compact string in " + timer.millis() + " ms (" + (double)n * 1000.0 / (double)timer.millis() + " calls/s)");
        }
        k = 10;
        while (k-- != 0) {
            s = new MutableString(target).loose();
            timer.reset();
            timer.start();
            int i = n;
            while (i-- != 0) {
                s.replace('&', amp);
            }
            timer.stop();
            System.err.println("Called replace() " + n + " times on a loose string in " + timer.millis() + " ms (" + (double)n * 1000.0 / (double)timer.millis() + " calls/s)");
        }
        k = 10;
        while (k-- != 0) {
            StringBuffer sb = new StringBuffer(target);
            timer.reset();
            timer.start();
            int i = n;
            while (i-- != 0) {
                int j = sb.length();
                while ((j = sb.lastIndexOf("&", j)) != -1) {
                    sb.replace(j, j + 1, "&amp;");
                    --j;
                }
            }
            timer.stop();
            System.err.println("Called replace() " + n + " times on a string buffer in " + timer.millis() + " ms (" + (double)n * 1000.0 / (double)timer.millis() + " calls/s)");
        }
        k = 10;
        while (k-- != 0) {
            StringBuffer2 sb2 = new StringBuffer2(target);
            timer.reset();
            timer.start();
            int i = n;
            while (i-- != 0) {
                int j = sb2.length();
                while ((j = sb2.lastIndexOf('&', j)) != -1) {
                    sb2.replace(j, j + 1, "&amp;");
                    --j;
                }
            }
            timer.stop();
            System.err.println("Called replace() " + n + " times on an unsychronised string buffer in " + timer.millis() + " ms (" + (double)n * 1000.0 / (double)timer.millis() + " calls/s)");
        }
        k = 10;
        while (k-- != 0) {
            String st = new String(target);
            timer.reset();
            timer.start();
            int i = n;
            while (i-- != 0) {
                st = st.replaceAll("&", "&amp;");
            }
            timer.stop();
            System.err.println("Called replace() " + n + " times on a string in " + timer.millis() + " ms (" + (double)n * 1000.0 / (double)timer.millis() + " calls/s)");
        }
    }
}

