/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics;

import edu.unc.genomics.Assembly;
import edu.unc.genomics.ResourceManager;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.DataFormatException;
import org.apache.log4j.Logger;

public class AssemblyManager {
    private static final Logger log = Logger.getLogger(AssemblyManager.class);
    private static Assembly lastUsed;

    public static List<Assembly> getAvailableAssemblies() {
        ArrayList<Assembly> assemblies = new ArrayList<Assembly>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(ResourceManager.getAssembliesDirectory(), "*.{len}");){
            for (Path entry : stream) {
                log.debug((Object)("Loading assembly: " + entry));
                try {
                    Assembly a = new Assembly(entry);
                    assemblies.add(a);
                }
                catch (IOException | DataFormatException e1) {
                    log.warn((Object)("Error loading assembly: " + entry));
                }
            }
        }
        catch (IOException e) {
            log.error((Object)"Error listing assemblies");
            e.printStackTrace();
        }
        return assemblies;
    }

    public static void deleteAssembly(Assembly a) throws IOException {
        Files.deleteIfExists(a.getPath());
    }

    public static Assembly loadCustomAssembly(Path assemblyFile) throws IOException, DataFormatException {
        log.debug((Object)("Loading custom assembly from file: " + assemblyFile));
        Assembly a = new Assembly(assemblyFile);
        Files.copy(assemblyFile, ResourceManager.getAssembliesDirectory().resolve(assemblyFile.getFileName()), new CopyOption[0]);
        return a;
    }

    public static Assembly getLastUsed() {
        return lastUsed;
    }

    public static void setLastUsed(Assembly lastUsed) {
        AssemblyManager.lastUsed = lastUsed;
    }
}

