/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.index.remote;

import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntIterators;
import it.unimi.dsi.fastutil.objects.AbstractObjectIterator;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMaps;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import it.unimi.dsi.mg4j.index.AbstractIndexIterator;
import it.unimi.dsi.mg4j.index.AbstractIndexReader;
import it.unimi.dsi.mg4j.index.Index;
import it.unimi.dsi.mg4j.index.IndexIterator;
import it.unimi.dsi.mg4j.index.IndexReader;
import it.unimi.dsi.mg4j.index.payload.Payload;
import it.unimi.dsi.mg4j.index.remote.RemoteIndex;
import it.unimi.dsi.mg4j.index.remote.RemoteIndexServerConnection;
import it.unimi.dsi.mg4j.io.InputBitStream;
import it.unimi.dsi.mg4j.io.OutputBitStream;
import it.unimi.dsi.mg4j.search.Interval;
import it.unimi.dsi.mg4j.search.IntervalIterator;
import it.unimi.dsi.mg4j.search.IntervalIterators;
import it.unimi.dsi.mg4j.util.Fast;
import it.unimi.dsi.mg4j.util.MutableString;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.Socket;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;

public class RemoteIndexReader
extends AbstractIndexReader {
    private static final Logger LOGGER = Fast.getLogger(RemoteIndexReader.class);
    private static final boolean ASSERTS = false;
    private static final byte DOCUMENTS_BY_NAME = 0;
    private static final byte DOCUMENTS_BY_INDEX = 1;
    private static final byte PREFETCH = 2;
    private static final byte CLOSE = 3;
    private static final byte DISPOSE = 4;
    private static final byte SKIP_TO = 5;
    private static final byte SKIP = 6;
    protected final Index index;
    protected final RemoteIndexServerConnection connection;
    protected final RemoteIndexReaderIndexIterator remoteIndexIterator;
    protected final DataInputStream inputStream;
    protected final DataOutputStream outputStream;

    public RemoteIndexReader(RemoteIndex index, int bufferSize) throws IOException {
        this.index = index;
        this.connection = new RemoteIndexServerConnection(index.socketAddress, 1);
        this.inputStream = this.connection.inputStream;
        this.outputStream = this.connection.outputStream;
        this.remoteIndexIterator = new RemoteIndexReaderIndexIterator(bufferSize);
    }

    public void close() throws IOException, IllegalStateException {
        this.outputStream.writeByte(3);
        this.outputStream.flush();
        try {
            this.connection.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (!this.connection.socket.isClosed()) {
                LOGGER.warn((Object)("This " + this.getClass().getName() + " [" + this.toString() + "] should have been closed."));
                this.close();
            }
        }
        finally {
            super.finalize();
        }
    }

    public IndexIterator documents(int termNumber) throws IOException {
        this.remoteIndexIterator.flush();
        this.outputStream.writeByte(1);
        this.outputStream.writeInt(termNumber);
        this.outputStream.flush();
        this.remoteIndexIterator.term(null);
        this.remoteIndexIterator.reset(this.inputStream.readInt());
        this.remoteIndexIterator.prefetchDocs(false);
        return this.remoteIndexIterator;
    }

    public IndexIterator documents(CharSequence term) throws IOException {
        this.remoteIndexIterator.flush();
        this.outputStream.writeByte(0);
        new MutableString(term).writeSelfDelimUTF8(this.outputStream);
        this.outputStream.flush();
        this.remoteIndexIterator.term(term);
        this.remoteIndexIterator.reset(this.inputStream.readInt());
        this.remoteIndexIterator.prefetchDocs(false);
        return this.remoteIndexIterator;
    }

    public static class ServerThread
    extends it.unimi.dsi.mg4j.index.remote.ServerThread {
        private static final Logger LOGGER = Fast.getLogger(ServerThread.class);
        private static final boolean DEBUG = false;
        private final Index index;
        private final IndexReader indexReader;
        private IndexIterator indexIterator;

        public ServerThread(Socket socket, Index index) throws IOException {
            super(socket);
            this.index = index;
            this.indexReader = index.getReader();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                block14: while (true) {
                    byte command;
                    try {
                        command = this.inputStream.readByte();
                    }
                    catch (IOException e) {
                        LOGGER.warn((Object)"Socket has been probably closed", (Throwable)e);
                        return;
                    }
                    switch (command) {
                        case 3: {
                            this.indexReader.close();
                            return;
                        }
                        case 1: {
                            this.indexIterator = this.indexReader.documents(this.inputStream.readInt());
                            this.outputStream.writeInt(this.indexIterator.frequency());
                            this.outputStream.flush();
                            continue block14;
                        }
                        case 0: {
                            this.indexIterator = this.indexReader.documents(new MutableString().readSelfDelimUTF8(this.inputStream));
                            this.outputStream.writeInt(this.indexIterator.frequency());
                            this.outputStream.flush();
                            continue block14;
                        }
                        case 5: {
                            this.outputStream.writeInt(this.indexIterator.skipTo(this.inputStream.readInt()));
                            this.outputStream.flush();
                            continue block14;
                        }
                        case 6: {
                            this.outputStream.writeInt(this.indexIterator.skip(this.inputStream.readInt()));
                            this.outputStream.flush();
                            continue block14;
                        }
                        case 2: {
                            boolean alreadyOnFirst = this.inputStream.readBoolean();
                            int bufSize = this.inputStream.readInt();
                            for (int i = 0; (this.indexIterator.hasNext() || alreadyOnFirst && i == 0) && bufSize > 0; ++i) {
                                if (i > 0 || !alreadyOnFirst) {
                                    this.outputStream.writeInt(this.indexIterator.nextDocument());
                                    --bufSize;
                                }
                                if (this.index.hasPayloads) {
                                    OutputBitStream obs = new OutputBitStream(this.outputStream);
                                    this.index.payload.write(obs);
                                    obs.flush();
                                }
                                if (!this.index.hasCounts) continue;
                                int count = this.indexIterator.count();
                                this.outputStream.writeInt(count);
                                --bufSize;
                                if (!this.index.hasPositions) continue;
                                int[] position = this.indexIterator.positionArray();
                                for (int p = 0; p < count; ++p) {
                                    this.outputStream.writeInt(position[p]);
                                }
                                bufSize -= count;
                            }
                            this.outputStream.writeInt(-1);
                            this.outputStream.writeBoolean(this.indexIterator.hasNext());
                            this.outputStream.flush();
                            continue block14;
                        }
                        case 4: {
                            this.indexIterator.dispose();
                            return;
                        }
                    }
                    LOGGER.error((Object)("Unknown remote command: " + command));
                }
            }
            catch (EOFException e) {
                LOGGER.warn((Object)"The socket has been closed");
                return;
            }
            catch (Exception e) {
                LOGGER.fatal((Object)e, (Throwable)e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class RemoteIndexReaderIndexIterator
    extends AbstractIndexIterator
    implements IndexIterator {
        private final int bufferSize;
        private int next;
        private int last;
        private int frequency;
        private boolean exhausted;
        protected Payload payload;
        protected int count;
        protected final int[] position;
        private final RemoteIndexIntervalIterator intervalIterator;
        private final Index keyIndex;
        private final Reference2ReferenceMap<Index, IntervalIterator> singletonIntervalIterator;

        public RemoteIndexReaderIndexIterator(int bufferSize) {
            this.intervalIterator = RemoteIndexReader.this.index.hasPositions ? new RemoteIndexIntervalIterator() : null;
            this.keyIndex = RemoteIndexReader.this.index.keyIndex;
            this.singletonIntervalIterator = Reference2ReferenceMaps.singleton((Object)this.keyIndex, (Object)this.intervalIterator);
            this.bufferSize = bufferSize;
            this.position = new int[RemoteIndexReader.this.index.maxCount];
            this.exhausted = true;
        }

        @Override
        public Index index() {
            return this.keyIndex;
        }

        public void flush() throws IOException {
            if (!this.exhausted) {
                while (RemoteIndexReader.this.inputStream.readInt() >= 0) {
                }
                RemoteIndexReader.this.inputStream.readBoolean();
                this.exhausted = true;
            }
        }

        public void reset(int frequency) {
            this.frequency = frequency;
            this.exhausted = false;
            this.last = -1;
            this.next = -1;
        }

        public void prefetchDocs(boolean alreadyOnFirst) throws IOException {
            RemoteIndexReader.this.outputStream.writeByte(2);
            RemoteIndexReader.this.outputStream.writeBoolean(alreadyOnFirst);
            RemoteIndexReader.this.outputStream.writeInt(this.bufferSize);
            RemoteIndexReader.this.outputStream.flush();
        }

        private int advance() {
            if (this.next >= 0) {
                return this.next;
            }
            try {
                this.next = RemoteIndexReader.this.inputStream.readInt();
                if (this.next < 0) {
                    if (!RemoteIndexReader.this.inputStream.readBoolean()) {
                        this.exhausted = true;
                        return -1;
                    }
                    this.prefetchDocs(false);
                    this.next = RemoteIndexReader.this.inputStream.readInt();
                }
                return this.next;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public int document() {
            if (this.last < 0) {
                throw new IllegalStateException();
            }
            return this.last;
        }

        @Override
        public int skipTo(int p) {
            try {
                if (p <= this.last) {
                    return this.last;
                }
                if (this.exhausted) {
                    return Integer.MAX_VALUE;
                }
                if (this.next < 0) {
                    this.next = RemoteIndexReader.this.inputStream.readInt();
                }
                while (this.next >= 0 && this.next < p) {
                    if (RemoteIndexReader.this.index.hasCounts) {
                        this.count = RemoteIndexReader.this.inputStream.readInt();
                        if (RemoteIndexReader.this.index.hasPositions) {
                            for (int i = 0; i < this.count; ++i) {
                                RemoteIndexReader.this.inputStream.readInt();
                            }
                        }
                    }
                    this.next = RemoteIndexReader.this.inputStream.readInt();
                }
                if (this.next >= 0) {
                    return this.nextInt();
                }
                this.exhausted = !RemoteIndexReader.this.inputStream.readBoolean();
                if (this.exhausted) {
                    return Integer.MAX_VALUE;
                }
                RemoteIndexReader.this.outputStream.writeByte(5);
                RemoteIndexReader.this.outputStream.writeInt(p);
                RemoteIndexReader.this.outputStream.flush();
                int result = RemoteIndexReader.this.inputStream.readInt();
                if (result == Integer.MAX_VALUE) {
                    this.exhausted = true;
                    return Integer.MAX_VALUE;
                }
                this.prefetchDocs(true);
                this.next = result;
                return this.nextInt();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public boolean hasNext() {
            if (this.exhausted) {
                return false;
            }
            if (this.next >= 0) {
                return true;
            }
            this.next = this.advance();
            return !this.exhausted;
        }

        @Override
        public int nextInt() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.last = this.next;
            this.next = -1;
            try {
                if (RemoteIndexReader.this.index.hasPayloads) {
                    this.payload.read(new InputBitStream(RemoteIndexReader.this.inputStream, 0));
                }
                if (RemoteIndexReader.this.index.hasCounts) {
                    this.count = RemoteIndexReader.this.inputStream.readInt();
                    if (RemoteIndexReader.this.index.hasPositions) {
                        for (int i = 0; i < this.count; ++i) {
                            this.position[i] = RemoteIndexReader.this.inputStream.readInt();
                        }
                        this.intervalIterator.reset();
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return this.last;
        }

        void closeConnectionQuietly() {
        }

        @Override
        public void dispose() throws IOException {
            RemoteIndexReader.this.close();
        }

        @Override
        public int nextDocument() {
            return this.hasNext() ? this.nextInt() : -1;
        }

        @Override
        public int frequency() {
            return this.frequency;
        }

        @Override
        public Payload payload() {
            return this.payload;
        }

        @Override
        public int count() {
            return this.count;
        }

        @Override
        public IntIterator positions() {
            return IntIterators.wrap((int[])this.position);
        }

        @Override
        public int positions(int[] p) {
            System.arraycopy(this.position, 0, p, 0, Math.min(this.count, p.length));
            return p.length < this.position.length ? -this.count : this.count;
        }

        @Override
        public int[] positionArray() {
            return this.position;
        }

        @Override
        public ReferenceSet<Index> indices() {
            return RemoteIndexReader.this.index.singletonSet;
        }

        @Override
        public IntervalIterator intervalIterator(Index index) {
            if (index != this.keyIndex || !index.hasPositions) {
                return IntervalIterators.TRUE;
            }
            return this.count > 0 ? this.intervalIterator : IntervalIterators.FALSE;
        }

        @Override
        public IntervalIterator intervalIterator() {
            return this.intervalIterator(this.keyIndex);
        }

        @Override
        public Reference2ReferenceMap<Index, IntervalIterator> intervalIterators() {
            return this.singletonIntervalIterator;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class RemoteIndexIntervalIterator
        extends AbstractObjectIterator<Interval>
        implements IntervalIterator {
            private int pos;

            private RemoteIndexIntervalIterator() {
            }

            @Override
            public Interval next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return Interval.valueOf(RemoteIndexReaderIndexIterator.this.position[this.pos++]);
            }

            @Override
            public Interval nextInterval() {
                return this.pos < RemoteIndexReaderIndexIterator.this.count ? Interval.valueOf(RemoteIndexReaderIndexIterator.this.position[this.pos++]) : null;
            }

            @Override
            public void reset() {
                this.pos = 0;
            }

            @Override
            public int extent() {
                return 1;
            }

            @Override
            public boolean hasNext() {
                return this.pos < RemoteIndexReaderIndexIterator.this.count;
            }
        }
    }
}

