/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.search;

import it.unimi.dsi.fastutil.objects.Reference2ReferenceArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMaps;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import it.unimi.dsi.mg4j.index.Index;
import it.unimi.dsi.mg4j.search.AbstractDocumentIterator;
import it.unimi.dsi.mg4j.search.DocumentIterator;
import it.unimi.dsi.mg4j.search.IntervalIterator;
import it.unimi.dsi.mg4j.search.IntervalIterators;
import it.unimi.dsi.mg4j.search.visitor.DocumentIteratorVisitor;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotDocumentIterator
extends AbstractDocumentIterator {
    private static final boolean DEBUG = false;
    private static final boolean ASSERTS = false;
    private final DocumentIterator documentIterator;
    private final Index soleIndex;
    private final int numberOfDocuments;
    private final Reference2ReferenceMap<Index, IntervalIterator> unmodifiableIntervalIterators;
    private int nextToSkip;
    private int nextCandidate;

    protected NotDocumentIterator(DocumentIterator documentIterator, int numberOfDocuments) throws IOException {
        int n;
        this.documentIterator = documentIterator;
        this.numberOfDocuments = numberOfDocuments;
        this.nextToSkip = documentIterator.nextDocument();
        if (this.nextToSkip == -1) {
            this.nextToSkip = numberOfDocuments;
        }
        this.soleIndex = (n = documentIterator.indices().size()) == 1 ? (Index)this.indices().iterator().next() : null;
        Reference2ReferenceArrayMap iterators = new Reference2ReferenceArrayMap(n);
        for (Index i : this.indices()) {
            iterators.put((Object)i, (Object)IntervalIterators.TRUE);
        }
        this.unmodifiableIntervalIterators = Reference2ReferenceMaps.unmodifiable((Reference2ReferenceMap)iterators);
    }

    public static NotDocumentIterator getInstance(DocumentIterator it, int numberOfDocuments) throws IOException {
        return new NotDocumentIterator(it, numberOfDocuments);
    }

    @Override
    public ReferenceSet<Index> indices() {
        return this.documentIterator.indices();
    }

    @Override
    public int skipTo(int n) throws IOException {
        if (this.last >= n) {
            return this.last;
        }
        this.last = -1;
        this.next = -1;
        this.nextCandidate = n;
        this.nextToSkip = this.documentIterator.skipTo(n);
        if (this.nextToSkip == Integer.MAX_VALUE) {
            this.nextToSkip = this.numberOfDocuments;
        }
        return this.nextDocument() == -1 ? Integer.MAX_VALUE : this.last;
    }

    @Override
    public int nextDocument() throws IOException {
        if (this.next >= 0) {
            this.last = this.next;
            this.next = -1;
            return this.last;
        }
        while (this.nextCandidate < this.numberOfDocuments) {
            if (this.nextCandidate < this.nextToSkip) {
                this.last = this.nextCandidate++;
                return this.last;
            }
            ++this.nextCandidate;
            this.nextToSkip = this.documentIterator.nextDocument();
            if (this.nextToSkip != -1) continue;
            this.nextToSkip = this.numberOfDocuments;
        }
        return -1;
    }

    @Override
    public void dispose() throws IOException {
        this.documentIterator.dispose();
    }

    @Override
    public boolean accept(DocumentIteratorVisitor visitor) throws IOException {
        return visitor.visitPre(this) && this.documentIterator.accept(visitor) && visitor.visitPost(this);
    }

    @Override
    public boolean acceptOnTruePaths(DocumentIteratorVisitor visitor) {
        return visitor.visitPre(this) && visitor.visitPost(this);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.documentIterator + ")";
    }

    @Override
    public Reference2ReferenceMap<Index, IntervalIterator> intervalIterators() {
        return this.unmodifiableIntervalIterators;
    }

    @Override
    public IntervalIterator intervalIterator() {
        if (this.soleIndex == null) {
            throw new IllegalStateException();
        }
        return IntervalIterators.TRUE;
    }

    @Override
    public IntervalIterator intervalIterator(Index index) {
        return IntervalIterators.TRUE;
    }
}

