/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.util;

import it.unimi.dsi.mg4j.util.Fast;
import java.io.PrintStream;

@Deprecated
public final class ProgressMeter {
    private long start;
    private long stop;
    private long count;
    private long lastCount;
    private long expectedUpdates;
    private long last;
    private int quantum;
    private String itemsName;
    private boolean shownQuantum;
    public final PrintStream out;

    public ProgressMeter() {
        this(1);
    }

    public ProgressMeter(int quantum) {
        this(quantum, "items");
    }

    public ProgressMeter(int quantum, String itemsName) {
        this(quantum, itemsName, System.err);
    }

    public ProgressMeter(int quantum, String itemsName, PrintStream out) {
        this.out = out;
        this.quantum = quantum;
        this.itemsName = itemsName;
        this.expectedUpdates = -1L;
    }

    public void update() {
        if (++this.count % (long)this.quantum != 0L) {
            return;
        }
        this.updateInternal();
    }

    private void updateInternal() {
        long n;
        if (!this.shownQuantum && this.quantum != 1) {
            this.shownQuantum = true;
            double itemsPerSec = (double)this.count / ((double)this.millis() / 1000.0);
            long millisToEnd = Math.round((double)(this.expectedUpdates - this.count) / (itemsPerSec / 1000.0));
            this.out.print("[. = " + Fast.format(this.quantum) + " " + this.itemsName + ", " + Fast.format(itemsPerSec) + " " + this.itemsName + "/s" + (this.expectedUpdates > 0L ? "; " + Fast.format(100L * this.count / this.expectedUpdates) + "% done, " + this.millis2hms(millisToEnd) + " to end" : "") + "]");
        }
        if ((n = this.count / (long)this.quantum) % 100L == 0L) {
            long deltaCount = this.count - this.lastCount;
            long deltaTime = System.currentTimeMillis() - this.last;
            double itemPerSec = (double)deltaCount * 1000.0 / (double)(deltaTime + 1L);
            long millisToEnd = Math.round((double)(this.expectedUpdates - this.count) / (itemPerSec / 1000.0));
            this.out.print("[" + Fast.format(this.count) + " " + this.itemsName + ", " + this.millis2hms(this.millis()) + ", " + Fast.format(itemPerSec) + " " + this.itemsName + "/s" + (this.expectedUpdates > 0L ? "; " + Fast.format(100L * this.count / this.expectedUpdates) + "% done, " + this.millis2hms(millisToEnd) + " to end" : "") + "]");
            this.lastCount += deltaCount;
            this.last += deltaTime;
            return;
        }
        if (n % 10L == 0L) {
            this.out.print("+");
            return;
        }
        this.out.print(".");
    }

    public void quantum(int quantum) {
        this.quantum = quantum;
    }

    public int quantum() {
        return this.quantum;
    }

    public void count(long count) {
        this.count = count;
    }

    public long count() {
        return this.count;
    }

    public void expectedUpdates(long num) {
        this.expectedUpdates = num;
    }

    public long expectedUpdates() {
        return this.expectedUpdates;
    }

    public void itemsName(String itemsName) {
        this.itemsName = itemsName;
    }

    public String itemsName() {
        return this.itemsName;
    }

    public void start(CharSequence message) {
        if (message != null) {
            this.out.print(message);
        }
        this.start = this.last = System.currentTimeMillis();
        this.count = 0L;
        this.lastCount = 0L;
        this.shownQuantum = false;
        this.stop = -1L;
    }

    public void start() {
        this.start(null);
    }

    public void stop(CharSequence message) {
        if (this.stop != -1L) {
            return;
        }
        if (message != null) {
            this.out.println(message);
        }
        this.stop = System.currentTimeMillis();
        this.expectedUpdates = -1L;
    }

    public void stop() {
        this.stop(null);
    }

    public void done() {
        this.stop(" done.");
        this.out.println(this);
    }

    public long millis() {
        if (this.stop != -1L) {
            return this.stop - this.start;
        }
        return System.currentTimeMillis() - this.start;
    }

    private String millis2hms(long t) {
        if (t < 1000L) {
            return t + "ms";
        }
        long s = t / 1000L % 60L;
        long m = t / 1000L / 60L % 60L;
        long h = t / 3600000L;
        if (h == 0L && m == 0L) {
            return s + "s";
        }
        if (h == 0L) {
            return m + "m " + s + "s";
        }
        return h + "h " + m + "m " + s + "s";
    }

    public String toString() {
        long t = this.stop - this.start + 1L;
        if (t <= 0L) {
            return "Illegal meter state";
        }
        return "Elapsed: " + this.millis2hms(t) + (this.count != 0L ? " [" + Fast.format(this.count) + " " + this.itemsName + ", " + Fast.format((double)this.count / ((double)t / 1000.0)) + " " + this.itemsName + "/s]" : "");
    }
}

