/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.io;

import edu.unc.genomics.FastqEntry;
import edu.unc.genomics.io.SequenceFile;
import edu.unc.genomics.io.SequenceFileFormatException;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class FastqFile
extends SequenceFile<FastqEntry> {
    private static final Logger log = Logger.getLogger(FastqFile.class);
    private final BufferedReader reader;
    private final FastqIterator iter;

    public FastqFile(Path p) throws IOException {
        super(p);
        this.reader = Files.newBufferedReader(p, Charset.defaultCharset());
        this.iter = new FastqIterator();
    }

    @Override
    public Iterator<FastqEntry> iterator() {
        return this.iter;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    private class FastqIterator
    implements Iterator<FastqEntry> {
        private FastqEntry next;

        private FastqIterator() throws IOException {
            this.advance();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public FastqEntry next() {
            FastqEntry entry = this.next;
            try {
                this.advance();
            }
            catch (IOException e) {
                log.error((Object)"Error reading from FASTQ file");
                e.printStackTrace();
            }
            return entry;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot delete entries in FASTQ file");
        }

        private void advance() throws IOException {
            String id = FastqFile.this.reader.readLine();
            String seq = FastqFile.this.reader.readLine();
            String line3 = FastqFile.this.reader.readLine();
            String qual = FastqFile.this.reader.readLine();
            if (id != null && seq != null && qual != null) {
                if (!id.startsWith("@") || !line3.startsWith("+")) {
                    throw new SequenceFileFormatException("Invalid format in FASTQ file: " + FastqFile.this.p);
                }
                id = id.substring(1);
                this.next = new FastqEntry(id, seq, qual);
            } else {
                this.next = null;
            }
        }
    }
}

