/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.io;

import edu.unc.genomics.io.Contig;
import edu.unc.genomics.io.WigFileException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.broad.igv.bbfile.WigItem;

class VariableStepContig
extends Contig {
    private static final Logger log = Logger.getLogger(VariableStepContig.class);
    private static final long serialVersionUID = 3139905829545756903L;

    public VariableStepContig(String chr, int start, int stop, int span) {
        super(chr, start, stop, span);
    }

    public static VariableStepContig parse(String headerLine) throws WigFileException {
        String[] tokens = headerLine.split(" ");
        if (tokens.length == 0 || !tokens[0].equals("variableStep")) {
            throw new WigFileException("Not a valid variableStep header line: " + headerLine);
        }
        String chr = "";
        int start = 1;
        int span = 1;
        block8: for (int i = 1; i < tokens.length; ++i) {
            String s = tokens[i];
            String[] pair = s.split("=");
            if (pair.length != 2) {
                throw new WigFileException("Invalid keypair in variableStep header line: " + s);
            }
            String key = pair[0];
            String value = pair[1];
            switch (key) {
                case "chrom": {
                    chr = value;
                    continue block8;
                }
                case "span": {
                    span = Integer.parseInt(value);
                    continue block8;
                }
                default: {
                    throw new WigFileException("Invalid attribute in variableStep header line: " + key);
                }
            }
        }
        return new VariableStepContig(chr, start, -1, span);
    }

    @Override
    public String toString() {
        return "variableStep chrom=" + this.getChr() + " span=" + this.getSpan();
    }

    public VariableStepContigIterator query(RandomAccessFile raf, String chr, int start, int stop) throws IOException, WigFileException {
        return new VariableStepContigIterator(raf, chr, start, stop);
    }

    private class VariableStepContigIterator
    implements Iterator<WigItem> {
        private final RandomAccessFile raf;
        private final String chr;
        private final int low;
        private final int high;
        private int itemIndex = 0;
        private int bp;
        private float value;
        private boolean hasNextLine = false;

        public VariableStepContigIterator(RandomAccessFile raf, String chr, int start, int stop) throws IOException, WigFileException {
            String line;
            this.raf = raf;
            this.chr = chr;
            this.low = Math.max(VariableStepContig.this.getStart(), start);
            this.high = Math.min(VariableStepContig.this.getStop(), stop);
            int closestUpstream = VariableStepContig.this.getUpstreamIndexedBP(this.low);
            raf.seek(VariableStepContig.this.getIndex(closestUpstream));
            while ((line = raf.readLine()) != null) {
                if (line.startsWith("fixedStep") || line.startsWith("variableStep")) {
                    this.hasNextLine = false;
                    break;
                }
                int delim = line.indexOf(9);
                this.bp = Integer.parseInt(line.substring(0, delim));
                if (this.bp + VariableStepContig.this.getSpan() - 1 < this.low) continue;
                this.value = Float.parseFloat(line.substring(delim + 1));
                this.hasNextLine = true;
                break;
            }
        }

        @Override
        public boolean hasNext() {
            return this.hasNextLine && this.bp <= this.high;
        }

        @Override
        public WigItem next() {
            WigItem item = new WigItem(this.itemIndex++, this.chr, this.bp, this.bp + VariableStepContig.this.getSpan() - 1, this.value);
            try {
                String line = this.raf.readLine();
                if (line == null || line.startsWith("fixedStep") || line.startsWith("variableStep")) {
                    this.hasNextLine = false;
                } else {
                    int delim = line.indexOf(9);
                    this.bp = Integer.parseInt(line.substring(0, delim));
                    this.value = Float.parseFloat(line.substring(delim + 1));
                    this.hasNextLine = true;
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Error getting next item from Wig file");
            }
            return item;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove elements from Wig file");
        }
    }
}

