/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics;

import com.beust.jcommander.Parameter;
import edu.ucsc.genome.TrackHeader;
import edu.unc.genomics.Assembly;
import edu.unc.genomics.CommandLineTool;
import edu.unc.genomics.CommandLineToolException;
import edu.unc.genomics.Contig;
import edu.unc.genomics.Interval;
import edu.unc.genomics.ReadablePathValidator;
import edu.unc.genomics.io.IntervalFileReader;
import edu.unc.genomics.io.WigFileWriter;
import java.io.IOException;
import java.nio.file.Path;
import org.apache.log4j.Logger;

public abstract class ReadMapperTool
extends CommandLineTool {
    private static final Logger log = Logger.getLogger(ReadMapperTool.class);
    @Parameter(names={"-i", "--input"}, description="Input file", required=true, validateWith=ReadablePathValidator.class)
    public Path intervalFile;
    @Parameter(names={"-a", "--assembly"}, description="Genome assembly", required=true)
    public Assembly assembly;
    @Parameter(names={"-o", "--output"}, description="Output file", required=true)
    public Path outputFile;

    public abstract float[] compute(IntervalFileReader<? extends Interval> var1, Interval var2) throws IOException;

    @Override
    public final void run() throws IOException {
        log.debug((Object)"Processing reads and writing result to disk");
        TrackHeader header = TrackHeader.newWiggle();
        header.setName("Processed " + this.intervalFile.getFileName());
        header.setDescription("Processed " + this.intervalFile.getFileName());
        try (IntervalFileReader reader = IntervalFileReader.autodetect((Path)this.intervalFile);
             WigFileWriter writer = new WigFileWriter(this.outputFile, header);){
            for (String chr : reader.chromosomes()) {
                if (!this.assembly.includes(chr)) {
                    log.info((Object)("Skipping " + chr + " not in assembly " + this.assembly));
                    continue;
                }
                log.debug((Object)("Processing chromosome " + chr));
                int chunkStart = 1;
                while (chunkStart < this.assembly.getChrLength(chr)) {
                    int chunkStop = Math.min(chunkStart + 300000 - 1, this.assembly.getChrLength(chr));
                    Interval chunk = new Interval(chr, chunkStart, chunkStop);
                    log.debug((Object)("Processing chunk " + chunk));
                    float[] result = this.compute((IntervalFileReader<? extends Interval>)reader, chunk);
                    if (result.length != chunk.length()) {
                        log.error((Object)("Expected result length=" + chunk.length() + ", got=" + result.length));
                        throw new CommandLineToolException("Result of mapping computation is not the expected length!");
                    }
                    writer.write(new Contig(chunk, result));
                    chunkStart = chunkStop + 1;
                }
            }
        }
    }
}

