/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.io;

import edu.unc.genomics.Contig;
import edu.unc.genomics.Interval;
import edu.unc.genomics.io.WigFileException;
import edu.unc.genomics.io.WigFileReader;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import org.apache.log4j.Logger;
import org.broad.igv.bbfile.BBFileReader;
import org.broad.igv.bbfile.BBTotalSummaryBlock;
import org.broad.igv.bbfile.BigWigIterator;
import org.broad.igv.bbfile.RPChromosomeRegion;
import org.broad.igv.bbfile.WigItem;

public class BigWigFileReader
extends WigFileReader {
    private static final Logger log = Logger.getLogger(BigWigFileReader.class);
    private BBFileReader reader;
    private BBTotalSummaryBlock summary;

    public BigWigFileReader(Path p) throws IOException {
        super(p);
        log.debug((Object)("Opening BigWig file reader " + p));
        this.reader = new BBFileReader(p.toString());
        this.summary = this.reader.getTotalSummaryBlock();
    }

    public static boolean isBigWig(Path p) throws IOException {
        boolean isBigWig = false;
        try {
            BBFileReader reader = new BBFileReader(p.toString());
            isBigWig = reader.isBigWigFile();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return isBigWig;
    }

    @Override
    public void close() {
        log.debug((Object)("Closing BigWig file reader " + this.p));
    }

    @Override
    public synchronized Contig query(Interval interval) throws WigFileException {
        if (!this.includes(interval)) {
            throw new WigFileException("BigWigFile does not contain data for region: " + interval);
        }
        float[] values = new float[interval.length()];
        Arrays.fill(values, Float.NaN);
        BigWigIterator it = this.reader.getBigWigIterator(interval.getChr(), interval.low() - 1, interval.getChr(), interval.high(), false);
        while (it.hasNext()) {
            WigItem item = it.next();
            float value = item.getWigValue();
            if (Float.isNaN(value)) continue;
            for (int bp = item.getStartBase() + 1; bp <= item.getEndBase(); ++bp) {
                if (!interval.includes(bp)) continue;
                values[bp - interval.low()] = value;
            }
        }
        if (interval.isCrick()) {
            ArrayUtils.reverse((float[])values);
        }
        return new Contig(interval, values);
    }

    @Override
    public synchronized SummaryStatistics queryStats(Interval interval) throws WigFileException {
        if (!this.includes(interval)) {
            throw new WigFileException("BigWigFile does not contain data for region: " + interval);
        }
        SummaryStatistics stats = new SummaryStatistics();
        BigWigIterator it = this.reader.getBigWigIterator(interval.getChr(), interval.low() - 1, interval.getChr(), interval.high(), false);
        while (it.hasNext()) {
            WigItem item = it.next();
            float value = item.getWigValue();
            if (Float.isNaN(value)) continue;
            for (int bp = item.getStartBase() + 1; bp <= item.getEndBase(); ++bp) {
                if (!interval.includes(bp)) continue;
                stats.addValue((double)value);
            }
        }
        return stats;
    }

    @Override
    public synchronized Set<String> chromosomes() {
        return new LinkedHashSet<String>(this.reader.getChromosomeNames());
    }

    @Override
    public synchronized int getChrStart(String chr) {
        int chrID = this.reader.getChromosomeID(chr);
        RPChromosomeRegion region = this.reader.getChromosomeBounds(chrID, chrID);
        return region.getStartBase() + 1;
    }

    @Override
    public synchronized int getChrStop(String chr) {
        int chrID = this.reader.getChromosomeID(chr);
        RPChromosomeRegion region = this.reader.getChromosomeBounds(chrID, chrID);
        return region.getEndBase();
    }

    @Override
    public int getChrStep(String chr) {
        return 1;
    }

    @Override
    public int getChrSpan(String chr) {
        return 1;
    }

    @Override
    public synchronized boolean includes(String chr, int start, int stop) {
        int chrID = this.reader.getChromosomeID(chr);
        if (chrID == -1) {
            return false;
        }
        RPChromosomeRegion region = this.reader.getChromosomeBounds(chrID, chrID);
        return region.getStartBase() <= start && region.getEndBase() >= stop;
    }

    @Override
    public synchronized boolean includes(String chr) {
        return this.reader.getChromosomeID(chr) != -1;
    }

    @Override
    public synchronized long numBases() {
        return this.summary.getBasesCovered();
    }

    @Override
    public synchronized double total() {
        return this.summary.getSumData();
    }

    @Override
    public synchronized double mean() {
        return this.total() / (double)this.numBases();
    }

    @Override
    public synchronized double stdev() {
        return Math.sqrt((double)(this.summary.getSumSquares() / (float)this.numBases()) - Math.pow(this.mean(), 2.0));
    }

    @Override
    public synchronized double min() {
        return this.summary.getMinVal();
    }

    @Override
    public synchronized double max() {
        return this.summary.getMaxVal();
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder("BigWig file:\n");
        for (String chr : this.chromosomes()) {
            s.append("Chromosome ").append(chr).append(", start=").append(this.getChrStart(chr));
            s.append(", stop=").append(this.getChrStop(chr)).append("\n");
        }
        s.append("Basic Statistics:\n");
        s.append("\tMean:\t\t\t").append(this.mean()).append("\n");
        s.append("\tStandard Deviation:\t").append(this.stdev()).append("\n");
        s.append("\tTotal:\t\t\t").append(this.total()).append("\n");
        s.append("\tBases Covered:\t\t").append(this.numBases()).append("\n");
        s.append("\tMin value:\t\t").append(this.min()).append("\n");
        s.append("\tMax value:\t\t").append(this.max());
        return s.toString();
    }
}

