/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.optimization.direct;

import org.apache.commons.math3.analysis.MultivariateFunction;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.NumberIsTooLargeException;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.optimization.BaseMultivariateOptimizer;
import org.apache.commons.math3.optimization.BaseMultivariateSimpleBoundsOptimizer;
import org.apache.commons.math3.optimization.ConvergenceChecker;
import org.apache.commons.math3.optimization.GoalType;
import org.apache.commons.math3.optimization.PointValuePair;
import org.apache.commons.math3.optimization.direct.BaseAbstractMultivariateOptimizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseAbstractMultivariateSimpleBoundsOptimizer<FUNC extends MultivariateFunction>
extends BaseAbstractMultivariateOptimizer<FUNC>
implements BaseMultivariateOptimizer<FUNC>,
BaseMultivariateSimpleBoundsOptimizer<FUNC> {
    private double[] lowerBound;
    private double[] upperBound;

    protected BaseAbstractMultivariateSimpleBoundsOptimizer() {
    }

    protected BaseAbstractMultivariateSimpleBoundsOptimizer(ConvergenceChecker<PointValuePair> checker) {
        super(checker);
    }

    public double[] getLowerBound() {
        return (double[])this.lowerBound.clone();
    }

    public double[] getUpperBound() {
        return (double[])this.upperBound.clone();
    }

    @Override
    public PointValuePair optimize(int maxEval, FUNC f, GoalType goalType, double[] startPoint) {
        return this.optimize(maxEval, f, goalType, startPoint, null, null);
    }

    @Override
    public PointValuePair optimize(int maxEval, FUNC f, GoalType goalType, double[] startPoint, double[] lower, double[] upper) {
        double v;
        int i;
        int dim = startPoint.length;
        if (lower != null) {
            if (lower.length != dim) {
                throw new DimensionMismatchException(lower.length, dim);
            }
            for (i = 0; i < dim; ++i) {
                v = startPoint[i];
                double lo = lower[i];
                if (!(v < lo)) continue;
                throw new NumberIsTooSmallException(v, (Number)lo, true);
            }
        }
        if (upper != null) {
            if (upper.length != dim) {
                throw new DimensionMismatchException(upper.length, dim);
            }
            for (i = 0; i < dim; ++i) {
                v = startPoint[i];
                double hi = upper[i];
                if (!(v > hi)) continue;
                throw new NumberIsTooLargeException(v, (Number)hi, true);
            }
        }
        if (lower == null) {
            this.lowerBound = new double[dim];
            for (i = 0; i < dim; ++i) {
                this.lowerBound[i] = Double.NEGATIVE_INFINITY;
            }
        } else {
            this.lowerBound = (double[])lower.clone();
        }
        if (upper == null) {
            this.upperBound = new double[dim];
            for (i = 0; i < dim; ++i) {
                this.upperBound[i] = Double.POSITIVE_INFINITY;
            }
        } else {
            this.upperBound = (double[])upper.clone();
        }
        return super.optimize(maxEval, f, goalType, startPoint);
    }
}

