/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.nucleosomes;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.CommandLineToolException;
import edu.unc.genomics.Contig;
import edu.unc.genomics.Interval;
import edu.unc.genomics.ReadablePathValidator;
import edu.unc.genomics.WigMathTool;
import edu.unc.genomics.io.WigFileException;
import edu.unc.genomics.io.WigFileReader;
import edu.unc.utils.InclusionExclusion;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class PredictFAIRESignal
extends WigMathTool {
    private static final Logger log = Logger.getLogger(PredictFAIRESignal.class);
    @Parameter(names={"-i", "--input"}, description="Nucleosome occupancy (Wig)", required=true, validateWith=ReadablePathValidator.class)
    public Path inputFile;
    @Parameter(names={"-s", "--sonication"}, description="Sonication distribution", required=true, validateWith=ReadablePathValidator.class)
    public Path sonicationFile;
    @Parameter(names={"-e", "--efficiency"}, description="FAIRE efficiency / crosslinking coefficient")
    public float crosslink = 1.0f;
    @Parameter(names={"-x", "--extend"}, description="In silico read extension (bp), -1 for paired-end")
    public int extend = 250;
    WigFileReader reader;
    float[] sonication = new float[100];
    int minL = Integer.MAX_VALUE;
    int maxL = 0;
    float maxOcc;

    @Override
    public void setup() {
        try {
            this.reader = WigFileReader.autodetect((Path)this.inputFile);
        }
        catch (IOException e) {
            throw new CommandLineToolException(e);
        }
        this.addInputFile(this.reader);
        log.debug((Object)"Loading sonication fragment length distribution");
        float total = 0.0f;
        try (BufferedReader reader = Files.newBufferedReader(this.sonicationFile, Charset.defaultCharset());){
            String line;
            while ((line = reader.readLine()) != null) {
                String[] entry = line.split("\t");
                if (entry.length != 2) {
                    throw new CommandLineToolException("Invalid format for sonication distribution file");
                }
                int length = Integer.parseInt(entry[0]);
                float percent = Float.parseFloat(entry[1]);
                if (length >= this.sonication.length) {
                    this.sonication = Arrays.copyOf(this.sonication, Math.max(this.sonication.length + 100, length + 1));
                }
                if (length < this.minL) {
                    this.minL = length;
                }
                if (length > this.maxL) {
                    this.maxL = length;
                }
                this.sonication[length] = percent;
                total += percent;
            }
        }
        catch (IOException e) {
            log.fatal((Object)"Error loading sonication fragment length distribution");
            e.printStackTrace();
            throw new CommandLineToolException("Error loading sonication fragment length distribution");
        }
        this.sonication = Arrays.copyOfRange(this.sonication, 0, this.maxL + 1);
        log.debug((Object)("Loaded sonication distribution for lengths: " + this.minL + "-" + this.maxL + "bp"));
        int i = 0;
        while (i < this.sonication.length) {
            int n = i++;
            this.sonication[n] = this.sonication[n] / total;
        }
        this.maxOcc = (float)this.reader.max();
    }

    @Override
    public float[] compute(Interval chunk) throws IOException, WigFileException {
        int paddedStart = Math.max(chunk.getStart() - this.maxL, this.reader.getChrStart(chunk.getChr()));
        int paddedStop = Math.min(chunk.getStop() + this.maxL, this.reader.getChrStop(chunk.getChr()));
        Contig data = this.reader.query(chunk.getChr(), paddedStart, paddedStop);
        float[] result = data.get(chunk.getStart() - this.maxL, chunk.getStop() + this.maxL);
        int i = 0;
        while (i < result.length) {
            int n = i++;
            result[n] = result[n] / this.maxOcc;
        }
        float[] prediction = this.extend < 0 ? this.paired(chunk, result) : this.single(chunk, result);
        return prediction;
    }

    private float[] single(Interval chunk, float[] occ) {
        float[] watson = new float[occ.length];
        float[] crick = new float[occ.length];
        for (int i = this.minL; i <= this.maxL; ++i) {
            if (this.sonication[i] == 0.0f) continue;
            for (int j = 0; j < occ.length - i; ++j) {
                float pOccupied = InclusionExclusion.independent(occ, j, j + i);
                float pFAIRE = 1.0f - this.crosslink * pOccupied;
                float pFragment = this.sonication[i] * pFAIRE;
                int n = j;
                watson[n] = watson[n] + pFragment;
                int n2 = j + i - 1;
                crick[n2] = crick[n2] + pFragment;
            }
        }
        float[] prediction = new float[chunk.length()];
        for (int i = 0; i < occ.length; ++i) {
            for (int j = 0; j < this.extend; ++j) {
                if (i + j - this.maxL > 0 && i + j - this.maxL < prediction.length) {
                    int n = i + j - this.maxL;
                    prediction[n] = prediction[n] + watson[i];
                }
                if (i - j - this.maxL <= 0 || i - j - this.maxL >= prediction.length) continue;
                int n = i - j - this.maxL;
                prediction[n] = prediction[n] + crick[i];
            }
        }
        return prediction;
    }

    private float[] paired(Interval chunk, float[] occ) {
        float[] prediction = new float[chunk.length()];
        for (int i = this.minL; i < this.sonication.length; ++i) {
            if (this.sonication[i] == 0.0f) continue;
            for (int j = 0; j < occ.length - i; ++j) {
                float pOccupied = InclusionExclusion.independent(occ, j, j + i);
                float pFAIRE = 1.0f - this.crosslink * pOccupied;
                float pFragment = this.sonication[i] * pFAIRE;
                for (int k = 0; k < i; ++k) {
                    if (j + k - this.maxL <= 0 || j + k - this.maxL >= prediction.length) continue;
                    int n = j + k - this.maxL;
                    prediction[n] = prediction[n] + pFragment;
                }
            }
        }
        return prediction;
    }

    public static void main(String[] args) throws IOException, WigFileException {
        new PredictFAIRESignal().instanceMain(args);
    }
}

