/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.nucleosomes;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.CommandLineToolException;
import edu.unc.genomics.Contig;
import edu.unc.genomics.Interval;
import edu.unc.genomics.ReadablePathValidator;
import edu.unc.genomics.WigMathTool;
import edu.unc.genomics.io.WigFileException;
import edu.unc.genomics.io.WigFileReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class PredictDinucleosomes
extends WigMathTool {
    private static final Logger log = Logger.getLogger(PredictDinucleosomes.class);
    @Parameter(names={"-i", "--input"}, description="Dyad density (Wig)", required=true, validateWith=ReadablePathValidator.class)
    public Path inputFile;
    @Parameter(names={"-d", "--distribution"}, description="Dinucleosome read length distribution", required=true, validateWith=ReadablePathValidator.class)
    public Path distributionFile;
    @Parameter(names={"-n", "--nsize"}, description="Assumed nucleosome size (bp)")
    public int nucleosomeSize = 147;
    WigFileReader reader;
    float[] distribution = new float[100];
    int minL = Integer.MAX_VALUE;
    int maxL = 0;
    float max;

    @Override
    public void setup() {
        try {
            this.reader = WigFileReader.autodetect((Path)this.inputFile);
        }
        catch (IOException e) {
            throw new CommandLineToolException(e);
        }
        this.addInputFile(this.reader);
        log.debug((Object)"Loading fragment length distribution");
        float total = 0.0f;
        try (BufferedReader reader = Files.newBufferedReader(this.distributionFile, Charset.defaultCharset());){
            String line;
            while ((line = reader.readLine()) != null) {
                String[] entry = line.split("\t");
                if (entry.length != 2) {
                    throw new CommandLineToolException("Invalid format for fragment length distribution file");
                }
                int length = Integer.parseInt(entry[0]);
                float percent = Float.parseFloat(entry[1]);
                if (length >= this.distribution.length) {
                    this.distribution = Arrays.copyOf(this.distribution, Math.max(this.distribution.length + 100, length + 1));
                }
                if (length < this.minL) {
                    this.minL = length;
                }
                if (length > this.maxL) {
                    this.maxL = length;
                }
                this.distribution[length] = percent;
                total += percent;
            }
        }
        catch (IOException e) {
            log.fatal((Object)"Error loading fragment length distribution");
            e.printStackTrace();
            throw new CommandLineToolException("Error loading fragment length distribution");
        }
        this.distribution = Arrays.copyOfRange(this.distribution, 0, this.maxL + 1);
        log.debug((Object)("Loaded fragment distribution for lengths: " + this.minL + "-" + this.maxL + "bp"));
        int i = 0;
        while (i < this.distribution.length) {
            int n = i++;
            this.distribution[n] = this.distribution[n] / total;
        }
        this.max = (float)this.reader.max();
    }

    @Override
    public float[] compute(Interval chunk) throws IOException, WigFileException {
        int paddedStart = Math.max(chunk.getStart() - this.maxL, this.reader.getChrStart(chunk.getChr()));
        int paddedStop = Math.min(chunk.getStop() + this.maxL, this.reader.getChrStop(chunk.getChr()));
        Contig data = this.reader.query(chunk.getChr(), paddedStart, paddedStop);
        float[] result = data.get(chunk.getStart() - this.maxL, chunk.getStop() + this.maxL);
        int i = 0;
        while (i < result.length) {
            int n = i++;
            result[n] = result[n] / this.max;
        }
        float[] prediction = new float[chunk.length()];
        for (int l = this.minL; l <= this.maxL; ++l) {
            int internucleosomeDistance = l - this.nucleosomeSize;
            if (internucleosomeDistance <= 0) continue;
            for (int i2 = 0; i2 < result.length - internucleosomeDistance; ++i2) {
                float p = this.distribution[l] * result[i2] * result[i2 + internucleosomeDistance];
                for (int j = i2 - this.maxL - this.nucleosomeSize / 2; j <= i2 - this.maxL + this.nucleosomeSize / 2; ++j) {
                    if (j < 0 || j >= prediction.length) continue;
                    int n = j;
                    prediction[n] = prediction[n] + p;
                }
            }
        }
        return prediction;
    }

    public static void main(String[] args) throws IOException, WigFileException {
        new PredictDinucleosomes().instanceMain(args);
    }
}

