/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics;

import edu.unc.genomics.Interval;

public class ValuedInterval
extends Interval {
    private static final long serialVersionUID = 2976113135643438146L;
    protected Number value;

    public ValuedInterval(String chr, int start, int stop, String id, Number value) {
        super(chr, start, stop, id);
        this.value = value;
    }

    public ValuedInterval(String chr, int start, int stop, String id) {
        this(chr, start, stop, id, null);
    }

    public ValuedInterval(String chr, int start, int stop) {
        this(chr, start, stop, null);
    }

    @Override
    public String toBed() {
        String idStr = this.getId() == null ? "." : this.getId();
        String valueStr = this.getValue() == null ? "." : String.valueOf(this.getValue().intValue());
        return this.getChr() + "\t" + (this.low() - 1) + "\t" + this.high() + "\t" + idStr + "\t" + valueStr + "\t" + (Object)((Object)this.strand());
    }

    @Override
    public String toBedGraph() {
        if (this.getValue() == null) {
            return super.toBedGraph();
        }
        return super.toBedGraph() + "\t" + this.getValue().toString();
    }

    @Override
    public String toGFF() {
        String idStr = this.getId() == null ? "no_id" : this.getId();
        String valueStr = this.getValue() == null ? "." : this.getValue().toString();
        return this.getChr() + "\tSpotArray\tfeature\t" + this.low() + "\t" + this.high() + "\t" + valueStr + "\t" + (Object)((Object)this.strand()) + "\t.\tprobe_id=" + idStr + ";count=1";
    }

    public Number getValue() {
        return this.value;
    }

    public void setValue(Number value) {
        this.value = value;
    }
}

