/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics;

import com.beust.jcommander.IStringConverterFactory;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import edu.unc.genomics.AssemblyFactory;
import edu.unc.genomics.CommandLineToolException;
import edu.unc.genomics.PathFactory;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;

public abstract class CommandLineTool {
    public static final int DEFAULT_CHUNK_SIZE = 10000000;

    public abstract void run() throws IOException;

    public void instanceMain(String[] args) throws CommandLineToolException {
        JCommander jc = new JCommander((Object)this);
        jc.addConverterFactory((IStringConverterFactory)new PathFactory());
        jc.addConverterFactory((IStringConverterFactory)new AssemblyFactory());
        String[] nameParts = this.getClass().getName().split("\\.");
        String shortName = StringUtils.join((Object[])Arrays.copyOfRange(nameParts, nameParts.length - 2, nameParts.length), (char)'.');
        jc.setProgramName(shortName);
        try {
            jc.parse(args);
        }
        catch (ParameterException e) {
            System.err.println(e.getMessage());
            jc.usage();
            System.exit(-1);
        }
        try {
            this.run();
        }
        catch (IOException e) {
            throw new CommandLineToolException("IO error while running", e);
        }
    }
}

