/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.wigmath;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.CommandLineToolException;
import edu.unc.genomics.Interval;
import edu.unc.genomics.ReadablePathValidator;
import edu.unc.genomics.WigMathTool;
import edu.unc.genomics.io.WigFileException;
import edu.unc.genomics.io.WigFileReader;
import java.io.IOException;
import java.nio.file.Path;
import org.apache.log4j.Logger;

public class Subtract
extends WigMathTool {
    private static final Logger log = Logger.getLogger(Subtract.class);
    @Parameter(names={"-m", "--minuend"}, description="Minuend (top - file 1)", required=true, validateWith=ReadablePathValidator.class)
    public Path minuendFile;
    @Parameter(names={"-s", "--subtrahend"}, description="Subtrahend (bottom - file 2)", required=true, validateWith=ReadablePathValidator.class)
    public Path subtrahendFile;
    WigFileReader minuendReader;
    WigFileReader subtrahendReader;

    @Override
    public void setup() {
        log.debug((Object)"Initializing input files");
        try {
            this.minuendReader = WigFileReader.autodetect((Path)this.minuendFile);
            this.subtrahendReader = WigFileReader.autodetect((Path)this.subtrahendFile);
        }
        catch (IOException e) {
            throw new CommandLineToolException(e);
        }
        this.inputs.add(this.minuendReader);
        this.inputs.add(this.subtrahendReader);
        log.debug((Object)("Initialized " + this.inputs.size() + " input files"));
    }

    @Override
    public float[] compute(Interval chunk) throws IOException, WigFileException {
        float[] minuend = this.minuendReader.query(chunk).getValues();
        float[] subtrahend = this.subtrahendReader.query(chunk).getValues();
        for (int i = 0; i < minuend.length; ++i) {
            int n = i;
            minuend[n] = minuend[n] - subtrahend[i];
        }
        return minuend;
    }

    public static void main(String[] args) throws IOException, WigFileException {
        new Subtract().instanceMain(args);
    }
}

