/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.wigmath;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.CommandLineTool;
import edu.unc.genomics.ReadablePathValidator;
import edu.unc.genomics.io.WigFileException;
import edu.unc.genomics.io.WigFileReader;
import edu.unc.genomics.ngs.Autocorrelation;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.log4j.Logger;

public class Summary
extends CommandLineTool {
    private static final Logger log = Logger.getLogger(Autocorrelation.class);
    @Parameter(names={"-i", "--input"}, description="Input file", required=true, validateWith=ReadablePathValidator.class)
    public Path inputFile;
    @Parameter(names={"-o", "--output"}, description="Output file")
    public Path outputFile;

    @Override
    public void run() throws IOException {
        block25: {
            try (WigFileReader reader = WigFileReader.autodetect((Path)this.inputFile);){
                String summary = reader.toString();
                if (this.outputFile != null) {
                    log.debug((Object)"Writing to output file");
                    try (BufferedWriter writer = Files.newBufferedWriter(this.outputFile, Charset.defaultCharset(), new OpenOption[0]);){
                        writer.write(summary);
                        break block25;
                    }
                }
                System.out.println(summary);
            }
        }
    }

    public static void main(String[] args) throws IOException, WigFileException {
        new Summary().instanceMain(args);
    }
}

