/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.converters;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.CommandLineTool;
import edu.unc.genomics.GeneTrackEntry;
import edu.unc.genomics.Interval;
import edu.unc.genomics.io.BedGraphFileWriter;
import edu.unc.genomics.io.GeneTrackFileReader;
import java.io.IOException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.log4j.Logger;

public class GeneTrackToBedGraph
extends CommandLineTool {
    private static final Logger log = Logger.getLogger(GeneTrackToBedGraph.class);
    @Parameter(names={"-i", "--input"}, description="Input file (GeneTrack format)", required=true)
    public Path gtFile;
    @Parameter(names={"-o", "--output"}, description="Output file (BedGraph)", required=true)
    public Path outputFile;

    @Override
    public void run() throws IOException {
        log.debug((Object)"Initializing input/output files");
        try (GeneTrackFileReader gt = new GeneTrackFileReader(this.gtFile);
             BedGraphFileWriter writer = new BedGraphFileWriter(this.outputFile, new OpenOption[0]);){
            for (GeneTrackEntry entry : gt) {
                writer.write((Interval)entry);
            }
        }
    }

    public static void main(String[] args) {
        new GeneTrackToBedGraph().instanceMain(args);
    }
}

