/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.converters;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.CommandLineToolException;
import edu.unc.genomics.GeneTrackEntry;
import edu.unc.genomics.Interval;
import edu.unc.genomics.ReadMapperTool;
import edu.unc.genomics.io.IntervalFileReader;
import java.io.IOException;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class GeneTrackToWig
extends ReadMapperTool {
    private static final Logger log = Logger.getLogger(GeneTrackToWig.class);
    @Parameter(names={"-z", "--zero"}, description="Assume zero where there is no data (default = NaN)")
    public boolean defaultZero = false;
    @Parameter(names={"-s", "--shift"}, description="Shift from 5' end (bp)")
    public Integer shift;

    @Override
    public float[] compute(IntervalFileReader<? extends Interval> reader, Interval chunk) throws IOException {
        float[] sum = new float[chunk.length()];
        int[] count = new int[chunk.length()];
        int paddedStart = chunk.getStart();
        int paddedStop = chunk.getStop();
        if (this.shift != null) {
            paddedStart = Math.max(chunk.getStart() - this.shift - 1, 1);
            paddedStop = Math.min(chunk.getStop() + this.shift + 1, this.assembly.getChrLength(chunk.getChr()));
        }
        Iterator it = reader.query(chunk.getChr(), paddedStart, paddedStop);
        while (it.hasNext()) {
            int reverseShift;
            int forwardShift;
            GeneTrackEntry entry;
            try {
                entry = (GeneTrackEntry)it.next();
            }
            catch (ClassCastException e) {
                log.error((Object)"Input file does not appear to be GeneTrack format!");
                throw new CommandLineToolException("Input file does not appear to be GeneTrack format!");
            }
            int entryPos = entry.getStart();
            if (this.shift == null || this.shift == 0) {
                if (entryPos < chunk.getStart() || entryPos > chunk.getStop()) continue;
                int n = entryPos - chunk.getStart();
                sum[n] = sum[n] + entry.getValue().floatValue();
                int n2 = entryPos - chunk.getStart();
                count[n2] = count[n2] + 1;
                continue;
            }
            if (entry.getForward() > 0.0 && (forwardShift = entryPos + this.shift) >= chunk.getStart() && forwardShift <= chunk.getStop()) {
                int n = forwardShift - chunk.getStart();
                sum[n] = (float)((double)sum[n] + entry.getForward());
                int n3 = forwardShift - chunk.getStart();
                count[n3] = count[n3] + 1;
            }
            if (!(entry.getReverse() > 0.0) || (reverseShift = entryPos - this.shift) < chunk.getStart() || reverseShift > chunk.getStop()) continue;
            int n = reverseShift - chunk.getStart();
            sum[n] = (float)((double)sum[n] + entry.getReverse());
            int n4 = reverseShift - chunk.getStart();
            count[n4] = count[n4] + 1;
        }
        for (int i = 0; i < sum.length; ++i) {
            if (count[i] != 0 || this.defaultZero) continue;
            sum[i] = Float.NaN;
        }
        return sum;
    }

    public static void main(String[] args) {
        new GeneTrackToWig().instanceMain(args);
    }
}

