/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.wigmath;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.CommandLineToolException;
import edu.unc.genomics.Interval;
import edu.unc.genomics.ReadablePathValidator;
import edu.unc.genomics.WigMathTool;
import edu.unc.genomics.io.WigFileException;
import edu.unc.genomics.io.WigFileReader;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class Shift
extends WigMathTool {
    private static final Logger log = Logger.getLogger(Shift.class);
    @Parameter(names={"-i", "--input"}, description="Input file", required=true, validateWith=ReadablePathValidator.class)
    public Path inputFile;
    @Parameter(names={"-m", "--mean"}, description="New mean")
    public float newMean = 0.0f;
    @Parameter(names={"-b", "--bychr"}, description="Shift each chromosome individually")
    public boolean byChromosome = false;
    WigFileReader reader;
    Map<String, Float> shifts = new HashMap<String, Float>();

    @Override
    public void setup() {
        try {
            this.reader = WigFileReader.autodetect((Path)this.inputFile);
            for (String chr : this.reader.chromosomes()) {
                float shift;
                if (this.byChromosome) {
                    float chrMean = (float)this.reader.queryStats(chr, this.reader.getChrStart(chr), this.reader.getChrStop(chr)).getMean();
                    log.debug((Object)("Mean of " + chr + " = " + chrMean));
                    shift = this.newMean - chrMean;
                } else {
                    shift = (float)((double)this.newMean - this.reader.mean());
                }
                this.shifts.put(chr, Float.valueOf(shift));
            }
        }
        catch (WigFileException | IOException e) {
            throw new CommandLineToolException(e);
        }
        this.inputs.add(this.reader);
    }

    @Override
    public float[] compute(Interval chunk) throws IOException, WigFileException {
        float[] result = this.reader.query(chunk).getValues();
        float shift = this.shifts.get(chunk.getChr()).floatValue();
        int i = 0;
        while (i < result.length) {
            int n = i++;
            result[n] = result[n] + shift;
        }
        return result;
    }

    public static void main(String[] args) throws IOException, WigFileException {
        new Shift().instanceMain(args);
    }
}

