/*
 * Decompiled with CFR 0.152.
 */
package org.genomeview.dnaproperties;

import be.abeel.gui.TitledComponent;
import be.abeel.io.ExtensionManager;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import net.sf.genomeview.core.Configuration;
import net.sf.genomeview.data.DataSourceHelper;
import net.sf.genomeview.data.IModel;
import net.sf.genomeview.data.Model;
import net.sf.genomeview.gui.StaticUtils;
import net.sf.jannot.exception.ReadFailedException;
import net.sf.jannot.source.Locator;
import org.genomeview.dnaproperties.DNAProperty;
import org.genomeview.dnaproperties.PropertyCalculator;

public class AddPropertyTrackWindow
extends JFrame {
    private static final long serialVersionUID = -6521362293892223191L;
    private IModel model;

    public AddPropertyTrackWindow(IModel model) {
        this.model = model;
        this.setResizable(false);
        this.setContentPane(new AddStructuralTrackWindowContent(this));
        this.pack();
        this.setVisible(false);
        this.setDefaultCloseOperation(1);
        StaticUtils.center((Window)model.getGUIManager().getParent(), (Window)this);
    }

    class AddStructuralTrackWindowContent
    extends JPanel {
        private static final long serialVersionUID = -4957750279816155212L;

        public AddStructuralTrackWindowContent(final JFrame parent) {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.gridx = 0;
            gc.gridy = 0;
            gc.gridwidth = 2;
            gc.fill = 1;
            final JComboBox<DNAProperty> properties = new JComboBox<DNAProperty>();
            for (DNAProperty prop : DNAProperty.values()) {
                properties.addItem(prop);
            }
            properties.setSelectedItem(DNAProperty.DNADenaturation);
            this.add((Component)new TitledComponent("DNA physical property", properties), gc);
            ++gc.gridy;
            ++gc.gridy;
            JButton ok = new JButton("OK");
            ok.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    parent.setVisible(false);
                    Thread t = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            File of = this.getSaveFile();
                            if (of != null) {
                                try {
                                    PropertyCalculator.createTDF(AddPropertyTrackWindow.this.model.entries(), of, (DNAProperty)properties.getSelectedItem());
                                    DataSourceHelper.load((Model)((Model)AddPropertyTrackWindow.this.model), (Locator)new Locator(of.toString()));
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                                catch (URISyntaxException e) {
                                    e.printStackTrace();
                                }
                                catch (ReadFailedException e) {
                                    e.printStackTrace();
                                }
                            }
                        }

                        private File getSaveFile() {
                            JFileChooser chooser = new JFileChooser(Configuration.getFile((String)"lastDirectory"));
                            chooser.addChoosableFileFilter(new FileFilter(){

                                @Override
                                public String getDescription() {
                                    return "Select file to store output";
                                }

                                @Override
                                public boolean accept(File f) {
                                    return true;
                                }
                            });
                            chooser.setFileSelectionMode(0);
                            int returnVal = chooser.showSaveDialog(AddPropertyTrackWindow.this.model.getGUIManager().getParent());
                            if (returnVal == 0) {
                                File files = chooser.getSelectedFile();
                                files = ExtensionManager.extension((File)files, (String)"tdf");
                                return files;
                            }
                            return null;
                        }
                    });
                    t.start();
                }
            });
            ++gc.gridy;
            this.add((Component)ok, gc);
            ++gc.gridx;
            JButton close = new JButton("Cancel");
            close.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    parent.setVisible(false);
                }
            });
            this.add((Component)close, gc);
        }
    }
}

