/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import net.sf.samtools.SAMException;

public class Md5CalculatingInputStream
extends InputStream {
    private final InputStream is;
    private final MessageDigest md5;
    private final File digestFile;
    private String hash;

    public Md5CalculatingInputStream(InputStream is, File digestFile) {
        this.is = is;
        this.digestFile = digestFile;
        this.hash = null;
        try {
            this.md5 = MessageDigest.getInstance("MD5");
            this.md5.reset();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("MD5 algorithm not found", e);
        }
    }

    @Override
    public int read() throws IOException {
        int result = this.is.read();
        if (result != -1) {
            this.md5.update((byte)result);
        }
        return result;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int result = this.is.read(b);
        if (result != -1) {
            this.md5.update(b, 0, result);
        }
        return result;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int result = this.is.read(b, off, len);
        if (result != -1) {
            this.md5.update(b, off, result);
        }
        return result;
    }

    public String md5() {
        if (this.hash == null) {
            throw new SAMException("Attempting to access md5 digest before the entire file is read!  Call close first.");
        }
        return this.hash;
    }

    private String makeHash() {
        if (this.hash == null) {
            this.hash = new BigInteger(1, this.md5.digest()).toString(16);
            if (this.hash.length() != 32) {
                String zeros = "00000000000000000000000000000000";
                this.hash = "00000000000000000000000000000000".substring(0, 32 - this.hash.length()) + this.hash;
            }
            return this.hash;
        }
        throw new SAMException("MD5InputStream is already closed!");
    }

    @Override
    public void close() throws IOException {
        this.is.close();
        this.makeHash();
        if (this.digestFile != null) {
            BufferedWriter writer = new BufferedWriter(new FileWriter(this.digestFile));
            writer.write(this.hash);
            writer.close();
        }
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int readlimit) {
        throw new UnsupportedOperationException("mark() is not supported by the MD5CalculatingInputStream");
    }

    @Override
    public void reset() throws IOException {
        throw new UnsupportedOperationException("reset() is not supported by the MD5CalculatingInputStream");
    }

    @Override
    public long skip(long n) throws IOException {
        throw new UnsupportedOperationException("skip() is not supported by the MD5CalculatingInputStream");
    }

    @Override
    public int available() throws IOException {
        return this.is.available();
    }
}

