/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics;

import edu.unc.genomics.Job;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class SubmittedJob {
    private static int numJobs = 0;
    private final Future<?> future;
    private final int id = ++numJobs;
    private final Job job;

    public SubmittedJob(Job job, Future<?> future) {
        this.job = job;
        this.future = future;
    }

    public int getId() {
        return this.id;
    }

    public Job getJob() {
        return this.job;
    }

    public boolean isRunning() {
        return this.job.isRunning() && !this.isDone();
    }

    public boolean isDone() {
        return this.future.isDone();
    }

    public boolean succeeded() {
        return this.future.isDone() && !this.failed();
    }

    public boolean failed() {
        if (this.future.isDone()) {
            try {
                this.future.get();
                return false;
            }
            catch (InterruptedException | ExecutionException e) {
                return true;
            }
        }
        return false;
    }

    public Exception getException() {
        if (this.future.isDone()) {
            try {
                this.future.get();
                return null;
            }
            catch (InterruptedException | ExecutionException e) {
                return e;
            }
        }
        return null;
    }

    public String toString() {
        return "Job " + this.id + ": " + this.job.getName();
    }
}

