/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.ngs;

import com.beust.jcommander.Parameter;
import edu.emory.mathcs.jtransforms.fft.FloatFFT_1D;
import edu.unc.genomics.CommandLineTool;
import edu.unc.genomics.Interval;
import edu.unc.genomics.io.IntervalFile;
import edu.unc.genomics.io.WigFile;
import edu.unc.genomics.io.WigFileException;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class PowerSpectrum
extends CommandLineTool {
    private static final Logger log = Logger.getLogger(PowerSpectrum.class);
    @Parameter(names={"-i", "--input"}, description="Input file (Wig)", required=true)
    public WigFile inputFile;
    @Parameter(names={"-l", "--loci"}, description="Genomic loci (Bed format)", required=true)
    public IntervalFile<? extends Interval> loci;
    @Parameter(names={"-o", "--output"}, description="Output file (tabular)", required=true)
    public Path outputFile;

    private float[] abs2(float[] f) {
        int n = f.length;
        float[] ps = new float[n / 2 + 1];
        ps[0] = f[0] * f[0] / (float)(n * n);
        if (n % 2 == 0) {
            for (int k = 1; k < n / 2; ++k) {
                ps[k] = f[2 * k] * f[2 * k] + f[2 * k + 1] * f[2 * k + 1];
            }
            ps[n / 2] = f[1] * f[1];
        } else {
            for (int k = 1; k < (n - 1) / 2; ++k) {
                ps[k] = f[2 * k] * f[2 * k] + f[2 * k + 1] * f[2 * k + 1];
            }
            ps[(n - 1) / 2] = f[n - 1] * f[n - 1] + f[1] * f[1];
        }
        return ps;
    }

    @Override
    public void run() throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(this.outputFile, Charset.defaultCharset(), new OpenOption[0]);){
            writer.write("#chr\tlow\thigh\tid\talignment\tstrand\tPower Spectrum Values");
            writer.newLine();
            log.debug((Object)"Computing power spectrum for each window");
            int skipped = 0;
            for (Interval interval : this.loci) {
                Iterator wigIter;
                try {
                    wigIter = this.inputFile.query(interval);
                }
                catch (WigFileException | IOException e) {
                    log.debug((Object)("Skipping interval: " + interval.toString()));
                    ++skipped;
                    continue;
                }
                if (interval.length() > 1) {
                    int i;
                    float[] data = WigFile.flattenData((Iterator)wigIter, (int)interval.getStart(), (int)interval.getStop());
                    FloatFFT_1D fft = new FloatFFT_1D(data.length);
                    fft.realForward(data);
                    float[] ps = this.abs2(data);
                    float sum = 0.0f;
                    for (i = 1; i < ps.length; ++i) {
                        sum += ps[i];
                    }
                    i = 1;
                    while (i < ps.length) {
                        int n = i++;
                        ps[n] = ps[n] / sum;
                    }
                    writer.write(interval.toBed());
                    for (i = 1; i < Math.min(ps.length, 40); ++i) {
                        writer.write("\t" + ps[i]);
                    }
                    writer.newLine();
                    continue;
                }
                ++skipped;
                writer.write(interval.toBed());
                writer.newLine();
            }
            log.info((Object)("Skipped " + skipped + " intervals"));
        }
    }

    public static void main(String[] args) {
        new PowerSpectrum().instanceMain(args);
    }
}

