/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.io;

import edu.unc.genomics.Sequence;
import edu.unc.genomics.io.FastaFile;
import edu.unc.genomics.io.FastqFile;
import edu.unc.genomics.io.SequenceFileSniffer;
import edu.unc.genomics.io.SequenceFileSnifferException;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

abstract class SequenceFile<T extends Sequence>
implements Iterable<T>,
Closeable {
    private static final Logger log = Logger.getLogger(SequenceFile.class);
    protected final Path p;

    protected SequenceFile(Path p) {
        this.p = p;
    }

    public static SequenceFile<? extends Sequence> autodetect(Path p) throws SequenceFileSnifferException, IOException {
        SequenceFileSniffer sniffer = new SequenceFileSniffer(p);
        if (sniffer.isFasta()) {
            log.debug((Object)("Autodetected FASTA filetype for: " + p.getFileName().toString()));
            return new FastaFile(p);
        }
        if (sniffer.isFastq()) {
            log.debug((Object)("Autodetected FASTQ filetype for: " + p.getFileName().toString()));
            return new FastqFile(p);
        }
        if (sniffer.isTwoBit()) {
            throw new SequenceFileSnifferException("TwoBit files are not yet supported");
        }
        throw new SequenceFileSnifferException("Could not autodetect sequence file format");
    }

    public static List<Sequence> loadAll(Path p) throws SequenceFileSnifferException, IOException {
        ArrayList<Sequence> all = new ArrayList<Sequence>();
        try (SequenceFile<Sequence> input = SequenceFile.autodetect(p);){
            for (Sequence s : input) {
                all.add(s);
            }
        }
        return all;
    }

    public List<T> loadAll() {
        ArrayList<Sequence> all = new ArrayList<Sequence>();
        for (Sequence entry : this) {
            all.add(entry);
        }
        return all;
    }

    public Path getPath() {
        return this.p;
    }
}

