/*
 * Decompiled with CFR 0.152.
 */
package test.it.unimi.dsi.mg4j.index;

import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.mg4j.index.BitStreamIndex;
import it.unimi.dsi.mg4j.index.DiskBasedIndex;
import it.unimi.dsi.mg4j.index.IndexIterator;
import it.unimi.dsi.mg4j.index.MultiTermIndexIterator;
import it.unimi.dsi.mg4j.query.nodes.Query;
import it.unimi.dsi.mg4j.query.nodes.QueryBuilderVisitorException;
import it.unimi.dsi.mg4j.query.parser.QueryParserException;
import it.unimi.dsi.mg4j.query.parser.SimpleParser;
import it.unimi.dsi.mg4j.search.DocumentIterator;
import it.unimi.dsi.mg4j.search.DocumentIteratorBuilderVisitor;
import it.unimi.dsi.mg4j.search.Interval;
import it.unimi.dsi.mg4j.search.OrDocumentIterator;
import it.unimi.dsi.mg4j.search.visitor.AbstractDocumentIteratorVisitor;
import it.unimi.dsi.mg4j.tool.IndexBuilder;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import junit.framework.TestCase;
import org.apache.commons.configuration.ConfigurationException;
import test.it.unimi.dsi.mg4j.document.StringArrayDocumentCollection;
import test.it.unimi.dsi.mg4j.search.IntArrayIndexIterator;

public class MultiTermIndexIteratorTest
extends TestCase {
    private BitStreamIndex index;
    private SimpleParser simpleParser;

    public void setUp() throws ConfigurationException, SecurityException, IOException, URISyntaxException, ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        String basename = File.createTempFile(((Object)((Object)this)).getClass().getSimpleName(), "test").getCanonicalPath();
        new IndexBuilder(basename, new StringArrayDocumentCollection("a", "b", "c")).run();
        this.index = DiskBasedIndex.getInstance(basename + "-text", true, true);
        this.simpleParser = new SimpleParser(this.index.termProcessor);
    }

    public void testSkipBug() throws QueryParserException, QueryBuilderVisitorException, IOException {
        Query query = this.simpleParser.parse("a + b + c");
        DocumentIteratorBuilderVisitor documentIteratorBuilderVisitor = new DocumentIteratorBuilderVisitor(null, this.index, Integer.MAX_VALUE);
        DocumentIterator documentIterator = query.accept(documentIteratorBuilderVisitor);
        MultiTermIndexIteratorTest.assertEquals((int)2, (int)documentIterator.skipTo(2));
        documentIterator.dispose();
    }

    public void test() throws IOException {
        IntArrayIndexIterator i0 = new IntArrayIndexIterator(new int[]{0, 1, 2}, new int[][]{{0, 3}, {0}, {0}});
        IntArrayIndexIterator i1 = new IntArrayIndexIterator(new int[]{0, 2}, new int[][]{{1}, {1}});
        IntArrayIndexIterator i2 = new IntArrayIndexIterator(new int[]{0, 1, 3}, new int[][]{{2}, {2}, {0}});
        MultiTermIndexIterator multiTermIndexIterator = (MultiTermIndexIterator)MultiTermIndexIterator.getInstance(i0, i1, i2);
        MultiTermIndexIteratorTest.assertEquals((int)3, (int)multiTermIndexIterator.frequency());
        MultiTermIndexIteratorTest.assertTrue((boolean)multiTermIndexIterator.hasNext());
        MultiTermIndexIteratorTest.assertTrue((boolean)multiTermIndexIterator.hasNext());
        MultiTermIndexIteratorTest.assertEquals((int)0, (int)multiTermIndexIterator.nextDocument());
        MultiTermIndexIteratorTest.assertTrue((boolean)multiTermIndexIterator.intervalIterator().hasNext());
        MultiTermIndexIteratorTest.assertTrue((boolean)multiTermIndexIterator.intervalIterator().hasNext());
        MultiTermIndexIteratorTest.assertEquals((Object)Interval.valueOf(0), (Object)multiTermIndexIterator.intervalIterator().nextInterval());
        MultiTermIndexIteratorTest.assertEquals((Object)Interval.valueOf(1), (Object)multiTermIndexIterator.intervalIterator().nextInterval());
        MultiTermIndexIteratorTest.assertTrue((boolean)multiTermIndexIterator.intervalIterator().hasNext());
        MultiTermIndexIteratorTest.assertEquals((int)4, (int)multiTermIndexIterator.count());
        int[] position = multiTermIndexIterator.positionArray();
        MultiTermIndexIteratorTest.assertEquals((int)0, (int)position[0]);
        MultiTermIndexIteratorTest.assertEquals((int)1, (int)position[1]);
        MultiTermIndexIteratorTest.assertEquals((int)2, (int)position[2]);
        MultiTermIndexIteratorTest.assertEquals((int)3, (int)position[3]);
        MultiTermIndexIteratorTest.assertEquals((Object)Interval.valueOf(2), (Object)multiTermIndexIterator.intervalIterator().nextInterval());
        position = new int[4];
        multiTermIndexIterator.positions(position);
        MultiTermIndexIteratorTest.assertEquals((int)0, (int)position[0]);
        MultiTermIndexIteratorTest.assertEquals((int)1, (int)position[1]);
        MultiTermIndexIteratorTest.assertEquals((int)2, (int)position[2]);
        MultiTermIndexIteratorTest.assertEquals((int)3, (int)position[3]);
        MultiTermIndexIteratorTest.assertEquals((Object)Interval.valueOf(3), (Object)multiTermIndexIterator.intervalIterator().nextInterval());
        IntIterator positions = multiTermIndexIterator.positions();
        MultiTermIndexIteratorTest.assertEquals((int)0, (int)positions.nextInt());
        MultiTermIndexIteratorTest.assertEquals((int)1, (int)positions.nextInt());
        MultiTermIndexIteratorTest.assertEquals((int)2, (int)positions.nextInt());
        MultiTermIndexIteratorTest.assertEquals((int)3, (int)positions.nextInt());
        MultiTermIndexIteratorTest.assertFalse((boolean)positions.hasNext());
        MultiTermIndexIteratorTest.assertFalse((boolean)multiTermIndexIterator.intervalIterator().hasNext());
        MultiTermIndexIteratorTest.assertFalse((boolean)multiTermIndexIterator.intervalIterator().hasNext());
        MultiTermIndexIteratorTest.assertEquals((int)1, (int)multiTermIndexIterator.nextDocument());
        MultiTermIndexIteratorTest.assertTrue((boolean)multiTermIndexIterator.intervalIterator().hasNext());
        MultiTermIndexIteratorTest.assertTrue((boolean)multiTermIndexIterator.intervalIterator().hasNext());
        MultiTermIndexIteratorTest.assertEquals((Object)Interval.valueOf(0), (Object)multiTermIndexIterator.intervalIterator().nextInterval());
        MultiTermIndexIteratorTest.assertEquals((Object)Interval.valueOf(2), (Object)multiTermIndexIterator.intervalIterator().nextInterval());
        MultiTermIndexIteratorTest.assertEquals((int)2, (int)multiTermIndexIterator.count());
        position = multiTermIndexIterator.positionArray();
        MultiTermIndexIteratorTest.assertEquals((int)0, (int)position[0]);
        MultiTermIndexIteratorTest.assertEquals((int)2, (int)position[1]);
        positions = multiTermIndexIterator.positions();
        MultiTermIndexIteratorTest.assertEquals((int)0, (int)positions.nextInt());
        MultiTermIndexIteratorTest.assertEquals((int)2, (int)positions.nextInt());
        MultiTermIndexIteratorTest.assertFalse((boolean)positions.hasNext());
        MultiTermIndexIteratorTest.assertFalse((boolean)multiTermIndexIterator.intervalIterator().hasNext());
        MultiTermIndexIteratorTest.assertEquals((int)2, (int)multiTermIndexIterator.nextDocument());
        MultiTermIndexIteratorTest.assertTrue((boolean)multiTermIndexIterator.intervalIterator().hasNext());
        MultiTermIndexIteratorTest.assertTrue((boolean)multiTermIndexIterator.intervalIterator().hasNext());
        MultiTermIndexIteratorTest.assertEquals((Object)Interval.valueOf(0), (Object)multiTermIndexIterator.intervalIterator().nextInterval());
        MultiTermIndexIteratorTest.assertEquals((Object)Interval.valueOf(1), (Object)multiTermIndexIterator.intervalIterator().nextInterval());
        MultiTermIndexIteratorTest.assertEquals((int)2, (int)multiTermIndexIterator.count());
        position = multiTermIndexIterator.positionArray();
        MultiTermIndexIteratorTest.assertEquals((int)0, (int)position[0]);
        MultiTermIndexIteratorTest.assertEquals((int)1, (int)position[1]);
        positions = multiTermIndexIterator.positions();
        MultiTermIndexIteratorTest.assertEquals((int)0, (int)positions.nextInt());
        MultiTermIndexIteratorTest.assertEquals((int)1, (int)positions.nextInt());
        MultiTermIndexIteratorTest.assertFalse((boolean)positions.hasNext());
        MultiTermIndexIteratorTest.assertFalse((boolean)multiTermIndexIterator.intervalIterator().hasNext());
        MultiTermIndexIteratorTest.assertEquals((int)3, (int)multiTermIndexIterator.nextDocument());
        MultiTermIndexIteratorTest.assertTrue((boolean)multiTermIndexIterator.intervalIterator().hasNext());
        MultiTermIndexIteratorTest.assertEquals((Object)Interval.valueOf(0), (Object)multiTermIndexIterator.intervalIterator().nextInterval());
        MultiTermIndexIteratorTest.assertEquals((int)1, (int)multiTermIndexIterator.count());
        position = multiTermIndexIterator.positionArray();
        MultiTermIndexIteratorTest.assertEquals((int)0, (int)position[0]);
        positions = multiTermIndexIterator.positions();
        MultiTermIndexIteratorTest.assertEquals((int)0, (int)positions.nextInt());
        MultiTermIndexIteratorTest.assertFalse((boolean)positions.hasNext());
        MultiTermIndexIteratorTest.assertFalse((boolean)multiTermIndexIterator.intervalIterator().hasNext());
        MultiTermIndexIteratorTest.assertFalse((boolean)multiTermIndexIterator.hasNext());
        MultiTermIndexIteratorTest.assertFalse((boolean)multiTermIndexIterator.hasNext());
    }

    public void testMG4JMultiTermPositionIssue() throws IllegalAccessException, NoSuchMethodException, ConfigurationException, IOException, InvocationTargetException, InstantiationException, ClassNotFoundException, URISyntaxException {
        String basename = File.createTempFile(((Object)((Object)this)).getClass().getSimpleName(), "test").getCanonicalPath();
        new IndexBuilder(basename, new StringArrayDocumentCollection("A B C D E F F G G", "G A T H S K L J W L", "E S K D L J F K L S J D L S J D", "E B")).run();
        BitStreamIndex index = DiskBasedIndex.getInstance(basename + "-text", true, true);
        DocumentIterator iterator = OrDocumentIterator.getInstance(index.documents("A"), MultiTermIndexIterator.getInstance(index.documents("B"), index.documents("C"), index.documents("G")), index.documents("W"), MultiTermIndexIterator.getInstance(index.documents("S"), index.documents("J")));
        final int[] currDoc = new int[1];
        AbstractDocumentIteratorVisitor visitor = new AbstractDocumentIteratorVisitor(){

            public boolean visit(IndexIterator indexIterator) throws IOException {
                if (indexIterator.count() > 0 && indexIterator.document() == currDoc[0]) {
                    indexIterator.positionArray();
                }
                return true;
            }
        };
        for (int document = 0; document < index.numberOfDocuments; ++document) {
            currDoc[0] = iterator.skipTo(document);
            if (document != currDoc[0]) continue;
            iterator.accept(visitor);
        }
        while (iterator.hasNext()) {
            currDoc[0] = iterator.nextDocument();
            iterator.accept(visitor);
        }
    }
}

