/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.document;

import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.mg4j.document.Document;
import it.unimi.dsi.mg4j.document.DocumentFactory;
import it.unimi.dsi.mg4j.document.PropertyBasedDocumentFactory;
import it.unimi.dsi.mg4j.io.FastBufferedReader;
import it.unimi.dsi.mg4j.io.WordReader;
import it.unimi.dsi.mg4j.util.Properties;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import org.apache.commons.configuration.ConfigurationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentityDocumentFactory
extends PropertyBasedDocumentFactory {
    private static final long serialVersionUID = 1L;
    private String fieldName;
    private WordReader wordReader;
    private Class<? extends WordReader> wordReaderClass;

    @Override
    protected boolean parseProperty(String key, String[] values, Reference2ObjectMap<Enum<?>, Object> metadata) throws ConfigurationException {
        if (IdentityDocumentFactory.sameKey(PropertyBasedDocumentFactory.MetadataKeys.ENCODING, key)) {
            metadata.put((Object)PropertyBasedDocumentFactory.MetadataKeys.ENCODING, (Object)Charset.forName(IdentityDocumentFactory.ensureJustOne(key, values)).toString());
            return true;
        }
        if (IdentityDocumentFactory.sameKey(PropertyBasedDocumentFactory.MetadataKeys.WORDREADER, key)) {
            try {
                this.wordReaderClass = Class.forName(IdentityDocumentFactory.ensureJustOne(key, values));
                metadata.put((Object)PropertyBasedDocumentFactory.MetadataKeys.WORDREADER, (Object)this.wordReaderClass.toString());
            }
            catch (ClassNotFoundException e) {
                throw new ConfigurationException((Throwable)e);
            }
            return true;
        }
        if (IdentityDocumentFactory.sameKey(MetadataKeys.FIELDNAME, key)) {
            this.fieldName = IdentityDocumentFactory.ensureJustOne(key, values).toString();
            return true;
        }
        return super.parseProperty(key, values, metadata);
    }

    public IdentityDocumentFactory() {
        this.init();
    }

    private void init() {
        if (this.fieldName == null) {
            this.fieldName = "text";
        }
        try {
            this.wordReader = this.wordReaderClass == null ? new FastBufferedReader() : this.wordReaderClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public IdentityDocumentFactory(Reference2ObjectMap<Enum<?>, Object> defaultMetadata) {
        super(defaultMetadata);
        this.init();
    }

    public IdentityDocumentFactory(Properties properties) throws ConfigurationException {
        super(properties);
        this.init();
    }

    public IdentityDocumentFactory(String[] property) throws ConfigurationException {
        super(property);
        this.init();
    }

    @Override
    public IdentityDocumentFactory copy() {
        return new IdentityDocumentFactory(this.defaultMetadata);
    }

    @Override
    public int numberOfFields() {
        return 1;
    }

    @Override
    public String fieldName(int field) {
        this.ensureFieldIndex(field);
        return this.fieldName;
    }

    @Override
    public int fieldIndex(String fieldName) {
        return fieldName.equals(this.fieldName) ? 0 : -1;
    }

    @Override
    public DocumentFactory.FieldType fieldType(int field) {
        this.ensureFieldIndex(field);
        return DocumentFactory.FieldType.TEXT;
    }

    @Override
    public Document getDocument(final InputStream rawContent, final Reference2ObjectMap<Enum<?>, Object> metadata) {
        return new Document(){

            public CharSequence title() {
                return (CharSequence)IdentityDocumentFactory.this.resolve(PropertyBasedDocumentFactory.MetadataKeys.TITLE, metadata);
            }

            public String toString() {
                return ((Object)this.title()).toString();
            }

            public CharSequence uri() {
                return (CharSequence)IdentityDocumentFactory.this.resolve(PropertyBasedDocumentFactory.MetadataKeys.URI, metadata);
            }

            public Object content(int field) {
                IdentityDocumentFactory.this.ensureFieldIndex(field);
                try {
                    return new InputStreamReader(rawContent, (String)IdentityDocumentFactory.this.resolveNotNull(PropertyBasedDocumentFactory.MetadataKeys.ENCODING, metadata));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }

            public WordReader wordReader(int field) {
                IdentityDocumentFactory.this.ensureFieldIndex(field);
                return IdentityDocumentFactory.this.wordReader;
            }

            public void close() {
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MetadataKeys {
        FIELDNAME;

    }
}

