/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.index.cluster;

import it.unimi.dsi.mg4j.index.cluster.ContiguousDocumentalStrategy;

public class DocumentalStrategies {
    protected DocumentalStrategies() {
    }

    public static ContiguousDocumentalStrategy uniform(int numberOfLocalIndices, int numberOfDocuments) {
        if (numberOfLocalIndices > numberOfDocuments) {
            throw new IllegalArgumentException("The number of local indices (" + numberOfLocalIndices + ") is larger than the number of documents (" + numberOfDocuments + ")");
        }
        int intervalSize = numberOfDocuments / numberOfLocalIndices;
        int[] cutPoint = new int[numberOfLocalIndices + 1];
        cutPoint[numberOfLocalIndices] = numberOfDocuments;
        for (int i = 1; i < numberOfLocalIndices; ++i) {
            cutPoint[i] = intervalSize * i;
        }
        return new ContiguousDocumentalStrategy(cutPoint);
    }
}

