/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.index;

import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.mg4j.index.BitStreamHPIndexReader;
import it.unimi.dsi.mg4j.index.BitStreamIndex;
import it.unimi.dsi.mg4j.index.CompressionFlags;
import it.unimi.dsi.mg4j.index.IndexReader;
import it.unimi.dsi.mg4j.index.PrefixMap;
import it.unimi.dsi.mg4j.index.TermMap;
import it.unimi.dsi.mg4j.index.TermProcessor;
import it.unimi.dsi.mg4j.index.payload.Payload;
import it.unimi.dsi.mg4j.io.InputBitStream;
import it.unimi.dsi.mg4j.util.Fast;
import it.unimi.dsi.mg4j.util.Properties;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BitStreamHPIndex
extends BitStreamIndex {
    private static final long serialVersionUID = 0L;
    private static final Logger LOGGER = Fast.getLogger(BitStreamHPIndex.class);

    public BitStreamHPIndex(int numberOfDocuments, int numberOfTerms, long numberOfPostings, long numberOfOccurrences, int maxCount, Payload payload, CompressionFlags.Coding frequencyCoding, CompressionFlags.Coding pointerCoding, CompressionFlags.Coding countCoding, CompressionFlags.Coding positionCoding, int quantum, int height, int bufferSize, TermProcessor termProcessor, String field, Properties properties, TermMap termMap, PrefixMap prefixMap, IntList sizes, LongList offsets) {
        super(numberOfDocuments, numberOfTerms, numberOfPostings, numberOfOccurrences, maxCount, payload, frequencyCoding, pointerCoding, countCoding, positionCoding, quantum, height, bufferSize, termProcessor, field, properties, termMap, prefixMap, sizes, offsets);
        if (height < 0) {
            throw new IllegalArgumentException("Illegal height " + height);
        }
        if (quantum <= 0 || (quantum & -quantum) != quantum) {
            throw new IllegalArgumentException("Illegal quantum " + quantum);
        }
    }

    @Override
    protected Constructor<? extends IndexReader> getConstructor() {
        Class readerClass = BitStreamHPIndexReader.class;
        String className = BitStreamHPIndexReader.class.getPackage().getName() + ".wired." + BitStreamHPIndex.featureName(this.frequencyCoding) + BitStreamHPIndex.featureName(this.pointerCoding) + (this.hasPayloads ? "Payloads " : BitStreamHPIndex.featureName(this.countCoding) + BitStreamHPIndex.featureName(this.positionCoding)) + BitStreamHPIndexReader.class.getSimpleName();
        try {
            readerClass = Class.forName(className);
            LOGGER.info((Object)("Dynamically fetched reader class " + readerClass.getSimpleName()));
        }
        catch (Exception e) {
            LOGGER.info((Object)("Cannot fetch dynamically class " + className + "; falling back to generic (slower) class " + BitStreamHPIndexReader.class.getSimpleName()));
        }
        try {
            return readerClass.getConstructor(BitStreamHPIndex.class, InputBitStream.class, InputBitStream.class);
        }
        catch (Exception shouldntReallyHappen) {
            throw new RuntimeException("Cannot find suitable constructor in " + readerClass.getSimpleName());
        }
    }

    public abstract InputBitStream getPositionsInputBitStream(int var1) throws IOException;

    public abstract InputStream getPositionsInputStream() throws IOException;

    @Override
    public IndexReader getReader(int bufferSize) throws IOException {
        try {
            return (IndexReader)this.readerConstructor.newInstance(this, this.getInputBitStream(bufferSize == -1 ? this.bufferSize : bufferSize), this.getPositionsInputBitStream(bufferSize == -1 ? this.bufferSize : bufferSize));
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

