/*
 * Decompiled with CFR 0.152.
 */
package org.genomeview.dnaproperties;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.jannot.Entry;
import net.sf.jannot.EntrySet;
import net.sf.jannot.exception.ReadFailedException;
import net.sf.jannot.refseq.Sequence;
import net.sf.jannot.source.DataSourceFactory;
import net.sf.jannot.source.Locator;
import org.broad.igv.tdf.TDFBedTile;
import org.broad.igv.tdf.TDFDataset;
import org.broad.igv.tdf.TDFFixedTile;
import org.broad.igv.tdf.TDFGroup;
import org.broad.igv.tdf.TDFTile;
import org.broad.igv.tdf.TDFVaryTile;
import org.broad.igv.tdf.TDFWriter;
import org.broad.igv.tools.Accumulator;
import org.broad.igv.track.WindowFunction;
import org.broad.igv.util.collections.FloatArrayList;
import org.broad.igv.util.collections.IntArrayList;
import org.genomeview.dnaproperties.ConversionMap;
import org.genomeview.dnaproperties.ConversionMapDNAProperty;
import org.genomeview.dnaproperties.DNAProperty;

class PropertyCalculator {
    private static Logger log = Logger.getLogger(PropertyCalculator.class.toString());
    private boolean compressed = true;
    private boolean skipZeroes = false;
    private int nZoom;
    private int maxExtFactor = 0;
    private Zoom[] zoomLevels;
    private int nTracks;
    private String currentChr = "";
    private int currentChrLength;
    private int nPtsProcessed = 0;
    private int lastStartPosition = 0;
    private HashSet<String> skippedChromosomes = new HashSet();
    private TDFWriter writer;
    private Raw rawData;
    private File outputFile;
    private Accumulator allDataStats;
    private List<String> chromosomes = new ArrayList<String>();
    private Set<String> visitedChromosomes = new HashSet<String>();
    private Map<String, String> attributes = new HashMap<String, String>();
    private PrintStream out = System.out;
    private List<WindowFunction> windowFunctions = Arrays.asList(WindowFunction.mean);
    private String genomeID;
    private EntrySet genome;
    private ConversionMapDNAProperty dnaproperty;

    public static void createTDF(EntrySet seq, File tdf, DNAProperty prop) throws IOException, URISyntaxException {
        PropertyCalculator p = new PropertyCalculator(prop.toString(), tdf, seq, prop);
        long max = 0L;
        for (Entry e : seq) {
            if ((long)e.getMaximumLength() <= max) continue;
            max = e.getMaximumLength();
        }
        int zoom = 0;
        while (max / 2L > 50000L) {
            max /= 2L;
            ++zoom;
        }
        System.out.println("Zoom levels needed: " + zoom);
        p.count(zoom);
        p.finish();
    }

    public static void main(String[] args) throws ReadFailedException, URISyntaxException, IOException {
        Locator src = new Locator("n:/genomeview/genomes/mtb_h37rv_v2/MT_h37RV_V2.fasta");
        EntrySet set = DataSourceFactory.create((Locator)src, (Locator)new Locator("n:/genomeview/genomes/mtb_h37rv_v2/MT_h37RV_V2.fasta.fai")).read();
        File of = new File("c:/tabeel/gvtest/ajtprofile4.tdf");
        DNAProperty prop = DNAProperty.PropellorTwist;
        PropertyCalculator.createTDF(set, of, prop);
    }

    private PropertyCalculator(String genomeID, File outputFile, EntrySet genome, DNAProperty prop) {
        this.dnaproperty = (ConversionMapDNAProperty)prop;
        this.genomeID = genomeID;
        this.outputFile = outputFile;
        this.genome = genome;
        this.allDataStats = new Accumulator(this.windowFunctions);
    }

    private void setTrackParameters(String trackType, String trackLine, String[] trackNames) {
        if (this.outputFile != null && this.writer == null) {
            this.writer = new TDFWriter(this.outputFile, this.genomeID, trackType, trackLine, trackNames, this.windowFunctions, this.compressed);
            this.nTracks = trackNames.length;
            TDFGroup rootGroup = this.writer.getRootGroup();
            rootGroup.setAttribute("genome", this.genomeID);
            rootGroup.setAttribute("maxZoom", String.valueOf(this.nZoom));
        }
    }

    private void addData(String chr, int start, int end, float[] data, String name) {
        if (this.writer == null) {
            return;
        }
        if (this.skipZeroes) {
            boolean allZeroes = true;
            for (int i = 0; i < data.length; ++i) {
                if (data[i] == 0.0f) continue;
                allZeroes = false;
                break;
            }
            if (allZeroes) {
                return;
            }
        }
        if (this.skippedChromosomes.contains(chr)) {
            return;
        }
        if (this.currentChr != null && chr.equals(this.currentChr)) {
            if (start < this.lastStartPosition - this.maxExtFactor) {
                String msg = "Error: Data is not sorted @ " + chr + " " + start + "  (last position = " + this.lastStartPosition + "   max ext factor = " + this.maxExtFactor + ")";
                this.out.println(msg);
                throw new RuntimeException(msg);
            }
        } else {
            this.newChromosome(chr);
        }
        if (this.skippedChromosomes.contains(chr)) {
            return;
        }
        int chrLength = this.genome.getEntry(chr).getMaximumLength();
        if (start > chrLength) {
            log.info("Ignoring data from non-existent locus.  Probe = " + name + "  Locus = " + chr + ":" + start + "-" + end + ". " + chr + " length = " + chrLength);
            return;
        }
        this.rawData.addData(start, end, data, name);
        for (Zoom zl : this.zoomLevels) {
            zl.addData(start, end, data);
        }
        this.lastStartPosition = start;
    }

    private void newChromosome(String chr) {
        if (this.visitedChromosomes.contains(chr)) {
            String msg = "Error: Data is not ordered by start position. Chromosome " + chr + " appears in multiple blocks";
            this.out.println(msg);
            throw new RuntimeException(msg);
        }
        this.visitedChromosomes.add(chr);
        Entry c = this.genome.getEntry(chr);
        if (c == null) {
            this.out.println("Chromosome: " + chr + " not found in .genome file.  Skipping.");
            this.skippedChromosomes.add(chr);
        } else {
            this.chromosomes.add(chr);
            this.out.println();
            this.out.println("Processing chromosome " + chr);
            if (this.zoomLevels != null) {
                for (Zoom zl : this.zoomLevels) {
                    zl.close();
                }
            }
            if (this.rawData != null) {
                this.rawData.close();
            }
            this.currentChr = chr;
            this.currentChrLength = c.getMaximumLength();
            this.zoomLevels = new Zoom[this.nZoom + 1];
            for (int z = 0; z <= this.nZoom; ++z) {
                this.zoomLevels[z] = new Zoom(chr, z, this.currentChrLength);
            }
            this.rawData = new Raw(chr, this.currentChrLength, 100000);
        }
        this.lastStartPosition = 0;
    }

    private void finish() {
        if (this.writer == null) {
            return;
        }
        StringBuffer chrString = new StringBuffer();
        Iterator<String> iter = this.chromosomes.iterator();
        while (iter.hasNext()) {
            chrString.append(iter.next());
            if (!iter.hasNext()) continue;
            chrString.append(",");
        }
        this.writer.getRootGroup().setAttribute("chromosomes", chrString.toString());
        for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
            this.writer.getRootGroup().setAttribute(entry.getKey(), entry.getValue());
        }
        if (this.zoomLevels != null) {
            for (Zoom zl : this.zoomLevels) {
                zl.close();
            }
        }
        if (this.rawData == null) {
            this.out.println("No features were found that matched chromosomes in genome: " + this.genome);
        } else {
            this.rawData.close();
            this.allDataStats.finish();
            TDFGroup group = this.writer.getGroup("/");
            group.setAttribute("userPercentileAutoscaling", "true");
            for (WindowFunction wf : this.windowFunctions) {
                group.setAttribute(wf.getDisplayName(), String.valueOf(this.allDataStats.getValue(wf)));
            }
            this.writer.closeFile();
        }
    }

    private void count(int maxZoomValue) throws IOException, URISyntaxException {
        this.nZoom = maxZoomValue;
        this.setTrackParameters("DNA property", null, new String[]{"value"});
        int len = this.dnaproperty.length();
        System.out.println(this.dnaproperty.map);
        for (Entry e : this.genome) {
            int position = 0;
            byte[] buff = new byte[len];
            Sequence seq = e.sequence();
            String alignmentChr = e.getID();
            for (Character c : seq.get()) {
                System.arraycopy(buff, 1, buff, 0, buff.length - 1);
                buff[buff.length - 1] = ConversionMap.lowercase((byte)c.charValue());
                double d = 0.0;
                if (++position >= this.dnaproperty.length()) {
                    d = this.dnaproperty.get(buff);
                }
                this.addData(alignmentChr, position, position, new float[]{(float)d}, null);
            }
        }
    }

    private class Tile {
        int totalCount = 0;
        int tileNumber;
        int tileStart;
        int lastFinishedBin = 0;
        float binWidth;
        int nBins;
        int nonEmptyBins;
        Accumulator[][] accumulators;
        Map<WindowFunction, TDFDataset> datasets;

        Tile(Map<WindowFunction, TDFDataset> datasets, int zoomLevel, int tileNumber, int nBins, int tileWidth) {
            this.datasets = datasets;
            this.tileNumber = tileNumber;
            this.tileStart = tileNumber * tileWidth;
            this.nBins = nBins;
            this.binWidth = (float)tileWidth / (float)nBins;
            this.accumulators = new Accumulator[PropertyCalculator.this.nTracks][nBins];
        }

        void addData(int start, int end, float[] data) {
            ++this.totalCount;
            int startBin = Math.max(0, (int)((float)(start - this.tileStart) / this.binWidth));
            int endBin = Math.min(this.nBins - 1, (int)((float)(end - this.tileStart) / this.binWidth));
            int tmp = (int)((float)(start - this.tileStart - PropertyCalculator.this.maxExtFactor) / this.binWidth);
            for (int t = 0; t < PropertyCalculator.this.nTracks; ++t) {
                int b;
                for (b = this.lastFinishedBin; b < tmp; ++b) {
                    if (this.accumulators[t][b] == null) continue;
                    this.accumulators[t][b].finish();
                }
                this.lastFinishedBin = Math.max(0, tmp - 1);
                for (b = startBin; b <= endBin; ++b) {
                    if (this.accumulators[t][b] == null) {
                        this.accumulators[t][b] = new Accumulator(this.datasets.keySet());
                    }
                    this.accumulators[t][b].add(data[t]);
                }
            }
        }

        void close() {
            this.nonEmptyBins = 0;
            for (int t = 0; t < PropertyCalculator.this.nTracks; ++t) {
                for (int i = 0; i < this.nBins; ++i) {
                    if (this.accumulators[t][i] == null) continue;
                    this.accumulators[t][i].finish();
                    if (t != 0) continue;
                    ++this.nonEmptyBins;
                }
            }
            TDFFixedTile tile = null;
            for (WindowFunction wf : this.datasets.keySet()) {
                if ((double)this.nonEmptyBins < 0.5 * (double)this.nBins) {
                    int[] starts = new int[this.nonEmptyBins];
                    float[][] data = new float[PropertyCalculator.this.nTracks][this.nonEmptyBins];
                    int n = 0;
                    for (int i = 0; i < this.nBins; ++i) {
                        for (int t = 0; t < PropertyCalculator.this.nTracks; ++t) {
                            Accumulator acc = this.accumulators[t][i];
                            if (acc == null) continue;
                            data[t][n] = acc.getValue(wf);
                            if (t != PropertyCalculator.this.nTracks - 1) continue;
                            starts[n] = (int)((float)this.tileStart + (float)i * this.binWidth);
                            ++n;
                        }
                    }
                    tile = new TDFVaryTile(this.tileStart, this.binWidth, starts, data);
                } else {
                    float[][] data = new float[PropertyCalculator.this.nTracks][this.nBins];
                    for (int t = 0; t < PropertyCalculator.this.nTracks; ++t) {
                        for (int i = 0; i < this.nBins; ++i) {
                            data[t][i] = this.accumulators[t][i] == null ? Float.NaN : this.accumulators[t][i].getValue(wf);
                        }
                    }
                    tile = new TDFFixedTile(this.tileStart, this.tileStart, this.binWidth, data);
                }
                String dsName = this.datasets.get(wf).getName();
                try {
                    PropertyCalculator.this.writer.writeTile(dsName, this.tileNumber, (TDFTile)tile);
                }
                catch (IOException iOException) {
                    log.log(Level.SEVERE, "Error writing tile: " + dsName + " [" + this.tileNumber + "]", iOException);
                    throw new RuntimeException(iOException);
                }
            }
        }
    }

    private class Zoom {
        int level;
        int tileWidth;
        LinkedHashMap<Integer, Tile> activeTiles = new LinkedHashMap();
        Map<WindowFunction, TDFDataset> datasets = new HashMap<WindowFunction, TDFDataset>();

        Zoom(String chr, int level, int chrLength) {
            int nTiles = (int)Math.pow(2.0, level);
            this.tileWidth = chrLength / nTiles + 1;
            this.level = level;
            for (WindowFunction wf : PropertyCalculator.this.windowFunctions) {
                String dsName = "/" + chr + "/z" + level + "/" + wf.toString();
                this.datasets.put(wf, PropertyCalculator.this.writer.createDataset(dsName, TDFDataset.DataType.FLOAT, this.tileWidth, nTiles));
            }
        }

        private void addData(int start, int end, float[] data) {
            Tile t;
            Integer tileNumber;
            int startTile = start / this.tileWidth;
            int endTile = end / this.tileWidth;
            int tmp = (start - PropertyCalculator.this.maxExtFactor) / this.tileWidth;
            while (!this.activeTiles.isEmpty() && (tileNumber = this.activeTiles.keySet().iterator().next()) < tmp) {
                t = this.activeTiles.get(tileNumber);
                t.close();
                this.activeTiles.remove(tileNumber);
            }
            for (int i = startTile; i <= endTile; ++i) {
                t = this.activeTiles.get(i);
                if (t == null) {
                    t = new Tile(this.datasets, this.level, i, 700, this.tileWidth);
                    this.activeTiles.put(i, t);
                }
                t.addData(start, end, data);
            }
        }

        private void close() {
            for (Tile t : this.activeTiles.values()) {
                t.close();
            }
        }
    }

    private class Raw {
        private String dsName;
        private int tileWidth;
        private Map<Integer, RawTile> activeTiles = new HashMap<Integer, RawTile>();

        Raw(String chr, int chrLength, int tileWidth) {
            this.tileWidth = tileWidth;
            int nTiles = chrLength / tileWidth + 1;
            this.dsName = "/" + chr + "/raw";
            PropertyCalculator.this.writer.createDataset(this.dsName, TDFDataset.DataType.FLOAT, tileWidth, nTiles);
        }

        private void addData(int start, int end, float[] data, String name) {
            Integer tileNumber;
            int startTileNumber = start / this.tileWidth;
            int endTileNumber = end / this.tileWidth;
            int tmp = (start - PropertyCalculator.this.maxExtFactor) / this.tileWidth;
            while (!this.activeTiles.isEmpty() && (tileNumber = this.activeTiles.keySet().iterator().next()) < tmp) {
                RawTile t = this.activeTiles.get(tileNumber);
                t.close();
                this.activeTiles.remove(tileNumber);
            }
            for (int t = startTileNumber; t <= endTileNumber; ++t) {
                RawTile tile = this.activeTiles.get(t);
                if (tile == null) {
                    tile = new RawTile(this.dsName, t, t * this.tileWidth, (t + 1) * this.tileWidth);
                    this.activeTiles.put(t, tile);
                }
                tile.addData(start, end, data, name);
            }
            PropertyCalculator.this.nPtsProcessed++;
        }

        void close() {
            for (RawTile t : this.activeTiles.values()) {
                t.close();
            }
            this.activeTiles = null;
        }
    }

    private class RawTile {
        String dsName;
        int tileNumber;
        int tileStart;
        int tileEnd;
        IntArrayList startArray;
        IntArrayList endArray;
        ArrayList<String> nameList;
        FloatArrayList[] dataArray;

        RawTile(String dsName, int tileNumber, int start, int end) {
            this.dsName = dsName;
            this.tileNumber = tileNumber;
            this.tileStart = start;
            this.tileEnd = end;
            this.startArray = new IntArrayList();
            this.endArray = new IntArrayList();
            this.dataArray = new FloatArrayList[PropertyCalculator.this.nTracks];
            for (int i = 0; i < PropertyCalculator.this.nTracks; ++i) {
                this.dataArray[i] = new FloatArrayList();
            }
        }

        void addData(int start, int end, float[] data, String name) {
            if (start > this.tileEnd) {
                log.info("Warning: start position > tile end");
            }
            if (end < this.tileStart) {
                log.info("Warning: end position > tile end");
            }
            if (name != null && this.nameList == null) {
                this.nameList = new ArrayList();
            }
            int dataStart = Math.max(this.tileStart, start);
            int dataEnd = Math.min(this.tileEnd, end);
            this.startArray.add(dataStart);
            this.endArray.add(dataEnd);
            for (int i = 0; i < data.length; ++i) {
                this.dataArray[i].add(data[i]);
            }
            if (name != null) {
                this.nameList.add(name);
            }
        }

        void close() {
            try {
                if (this.startArray.size() > 0) {
                    int[] s = this.startArray.toArray();
                    int[] e = this.endArray.toArray();
                    float[][] d = new float[this.dataArray.length][this.dataArray[0].size()];
                    for (int i = 0; i < this.dataArray.length; ++i) {
                        d[i] = this.dataArray[i].toArray();
                    }
                    String[] n = this.nameList == null ? null : this.nameList.toArray(new String[0]);
                    TDFBedTile tile = new TDFBedTile(this.tileStart, s, e, d, n);
                    PropertyCalculator.this.writer.writeTile(this.dsName, this.tileNumber, (TDFTile)tile);
                    this.startArray.clear();
                    this.endArray.clear();
                    for (int i = 0; i < this.dataArray.length; ++i) {
                        this.dataArray[i].clear();
                    }
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }
}

