/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.nucleosomes;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.CommandLineTool;
import edu.unc.genomics.Interval;
import edu.unc.genomics.ReadablePathValidator;
import edu.unc.genomics.io.IntervalFile;
import edu.unc.genomics.nucleosomes.NucleosomeCall;
import edu.unc.genomics.nucleosomes.NucleosomeCallsFile;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class FindBoundaryNucleosomes
extends CommandLineTool {
    private static final Logger log = Logger.getLogger(FindBoundaryNucleosomes.class);
    @Parameter(names={"-i", "--input"}, description="Input file (nucleosome calls)", required=true, validateWith=ReadablePathValidator.class)
    public Path inputFile;
    @Parameter(names={"-l", "--loci"}, description="Boundary loci (Bed format)", required=true)
    public IntervalFile<? extends Interval> lociFile;
    @Parameter(names={"-o", "--output"}, description="Output file", required=true)
    public Path outputFile;
    private Map<String, List<NucleosomeCall>> nucs = new HashMap<String, List<NucleosomeCall>>();

    private List<NucleosomeCall> getIntervalNucleosomes(Interval i) {
        ArrayList<NucleosomeCall> intervalNucs = new ArrayList<NucleosomeCall>();
        if (this.nucs.containsKey(i.getChr())) {
            for (NucleosomeCall call : this.nucs.get(i.getChr())) {
                if (call.getDyad() < i.low() || call.getDyad() > i.high()) continue;
                intervalNucs.add(call);
            }
        }
        return intervalNucs;
    }

    @Override
    public void run() throws IOException {
        log.debug((Object)"Initializing input file");
        NucleosomeCallsFile nucsFile = new NucleosomeCallsFile(this.inputFile);
        log.debug((Object)"Loading all nucleosomes");
        Iterator i$ = nucsFile.iterator();
        while (i$.hasNext()) {
            NucleosomeCall nuc = (NucleosomeCall)i$.next();
            if (nuc == null) continue;
            if (!this.nucs.containsKey(nuc.getChr())) {
                this.nucs.put(nuc.getChr(), new ArrayList());
            }
            this.nucs.get(nuc.getChr()).add(nuc);
        }
        nucsFile.close();
        log.debug((Object)"Initializing output file");
        int skipped = 0;
        try (BufferedWriter writer = Files.newBufferedWriter(this.outputFile, Charset.defaultCharset(), new OpenOption[0]);){
            log.debug((Object)"Finding boundary nucleosomes for each interval");
            writer.write("#chr\tlow\thigh\tid\talignment\tstrand\t5' Dyad Position\t3' Dyad Position");
            writer.newLine();
            NucleosomeCall.DyadComparator comparator = new NucleosomeCall.DyadComparator();
            for (Interval interval : this.lociFile) {
                writer.write(interval.toBed());
                List<NucleosomeCall> intervalNucs = this.getIntervalNucleosomes(interval);
                if (intervalNucs.size() > 0) {
                    Collections.sort(intervalNucs, comparator);
                    if (interval.isCrick()) {
                        Collections.reverse(intervalNucs);
                    }
                    int fivePrime = intervalNucs.get(0).getDyad();
                    int threePrime = intervalNucs.get(intervalNucs.size() - 1).getDyad();
                    writer.write("\t" + fivePrime + "\t" + threePrime);
                } else {
                    ++skipped;
                    writer.write("\tNA\tNA");
                }
                writer.newLine();
            }
        }
        this.lociFile.close();
        log.info((Object)("Skipped " + skipped + " intervals with 0 nucleosomes"));
    }

    public static void main(String[] args) {
        new FindBoundaryNucleosomes().instanceMain(args);
    }
}

