/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.wigmath;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.io.WigFile;
import edu.unc.genomics.io.WigFileException;
import edu.unc.genomics.wigmath.WigMathTool;
import java.io.IOException;
import java.util.Iterator;
import org.apache.commons.math.stat.descriptive.DescriptiveStatistics;
import org.apache.log4j.Logger;

public class FilterOutlierRegions
extends WigMathTool {
    private static final Logger log = Logger.getLogger(FilterOutlierRegions.class);
    @Parameter(names={"-i", "--input"}, description="Input file", required=true)
    public WigFile inputFile;
    @Parameter(names={"-w", "--window"}, description="Window size", required=true)
    public int windowSize;
    @Parameter(names={"-t", "--threshold"}, description="Threshold (x mean)")
    public float threshold = 3.0f;
    double mean;
    DescriptiveStatistics stats;

    @Override
    public void setup() {
        this.inputs.add(this.inputFile);
        this.mean = this.inputFile.mean();
        this.stats = new DescriptiveStatistics();
        this.stats.setWindowSize(this.windowSize);
    }

    @Override
    public float[] compute(String chr, int start, int stop) throws IOException, WigFileException {
        this.stats.clear();
        int paddedStart = Math.max(start - this.windowSize / 2, this.inputFile.getChrStart(chr));
        int paddedStop = Math.min(stop + this.windowSize / 2, this.inputFile.getChrStop(chr));
        Iterator data = this.inputFile.query(chr, paddedStart, paddedStop);
        float[] result = WigFile.flattenData((Iterator)data, (int)paddedStart, (int)paddedStop);
        for (int i = 0; i < this.windowSize; ++i) {
            this.stats.addValue((double)result[i]);
        }
        return result;
    }

    public static void main(String[] args) throws IOException, WigFileException {
        new FilterOutlierRegions().instanceMain(args);
    }
}

