/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.visualization;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.BedEntry;
import edu.unc.genomics.CommandLineTool;
import edu.unc.genomics.Interval;
import edu.unc.genomics.ReadablePathValidator;
import edu.unc.genomics.io.BedFile;
import edu.unc.genomics.io.WigFile;
import edu.unc.genomics.io.WigFileException;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.log4j.Logger;

public class MatrixAligner
extends CommandLineTool {
    private static final Logger log = Logger.getLogger(MatrixAligner.class);
    @Parameter(names={"-i", "--input"}, description="Input file (Wig)", required=true)
    public WigFile inputFile;
    @Parameter(names={"-l", "--loci"}, description="Loci file (Bed)", required=true, validateWith=ReadablePathValidator.class)
    public Path lociFile;
    @Parameter(names={"-m", "--max"}, description="Truncate width (base pairs)")
    public Integer maxWidth;
    @Parameter(names={"-o", "--output"}, description="Output file (matrix2png format)", required=true)
    public Path outputFile;
    private List<BedEntry> loci;

    @Override
    public void run() throws IOException {
        log.debug((Object)"Loading alignment intervals");
        try (BedFile bed = new BedFile(this.lociFile);){
            this.loci = bed.loadAll();
        }
        int leftMax = Integer.MIN_VALUE;
        int rightMax = Integer.MIN_VALUE;
        for (BedEntry entry : this.loci) {
            int left = Math.abs(entry.getValue().intValue() - entry.getStart());
            int right = Math.abs(entry.getValue().intValue() - entry.getStop());
            if (left > leftMax) {
                leftMax = left;
            }
            if (right <= rightMax) continue;
            rightMax = right;
        }
        int m = this.loci.size();
        int n = leftMax + rightMax + 1;
        int alignmentPoint = leftMax;
        log.info((Object)("Intervals aligned into: " + m + "x" + n + " matrix"));
        log.info((Object)("Alignment point: " + alignmentPoint));
        int leftBound = 0;
        int rightBound = n - 1;
        if (this.maxWidth != null && this.maxWidth < n) {
            log.info((Object)("Truncated to: " + m + "x" + this.maxWidth));
            int leftAlignDistance = alignmentPoint;
            int rightAlignDistance = n - alignmentPoint - 1;
            int halfMax = this.maxWidth / 2;
            if (halfMax < leftAlignDistance && halfMax < rightAlignDistance) {
                leftBound = alignmentPoint - halfMax;
                rightBound = alignmentPoint + halfMax;
            } else if (leftAlignDistance <= rightAlignDistance) {
                rightBound = this.maxWidth;
            } else {
                leftBound = n - this.maxWidth;
            }
        }
        log.debug((Object)"Initializing output file");
        int count = 0;
        int skipped = 0;
        try (BufferedWriter writer = Files.newBufferedWriter(this.outputFile, Charset.defaultCharset(), new OpenOption[0]);){
            writer.write("ID");
            for (int i = leftBound - alignmentPoint; i <= rightBound - alignmentPoint; ++i) {
                writer.write("\t" + i);
            }
            writer.newLine();
            log.debug((Object)"Iterating over all intervals");
            Object[] row = new String[n];
            for (BedEntry entry : this.loci) {
                Arrays.fill(row, "-");
                Iterator result = null;
                try {
                    result = this.inputFile.query((Interval)entry);
                }
                catch (WigFileException e) {
                    ++skipped;
                    String id = entry.getId() == null ? entry.getId() : "Row " + count++;
                    writer.write(id);
                    for (int i = leftBound; i <= rightBound; ++i) {
                        writer.write("\t" + (String)row[i]);
                    }
                    writer.newLine();
                    continue;
                }
                float[] data = WigFile.flattenData((Iterator)result, (int)entry.getStart(), (int)entry.getStop());
                if (entry.isCrick()) {
                    ArrayUtils.reverse((float[])data);
                }
                int n1 = alignmentPoint - Math.abs(entry.getValue().intValue() - entry.getStart());
                int n2 = alignmentPoint + Math.abs(entry.getValue().intValue() - entry.getStop());
                assert (data.length == n2 - n1 + 1);
                for (int i = 0; i < data.length; ++i) {
                    if (Float.isNaN(data[i])) continue;
                    row[n1 + i] = String.valueOf(data[i]);
                }
                String id = entry.getId() == null ? entry.getId() : "Row " + count++;
                writer.write(id);
                for (int i = leftBound; i <= rightBound; ++i) {
                    writer.write("\t" + (String)row[i]);
                }
                writer.newLine();
            }
        }
        this.inputFile.close();
        log.debug((Object)(count + " intervals processed"));
        log.debug((Object)(skipped + " intervals skipped"));
    }

    public static void main(String[] args) {
        new MatrixAligner().instanceMain(args);
    }
}

