/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.nucleosomes;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.CommandLineToolException;
import edu.unc.genomics.ReadablePathValidator;
import edu.unc.genomics.io.WigFile;
import edu.unc.genomics.io.WigFileException;
import edu.unc.genomics.wigmath.WigMathTool;
import java.io.IOException;
import java.util.Iterator;
import org.apache.commons.math.stat.descriptive.DescriptiveStatistics;
import org.apache.log4j.Logger;

public class PercusDecomposition
extends WigMathTool {
    private static final Logger log = Logger.getLogger(PercusDecomposition.class);
    @Parameter(names={"-d", "--dyads"}, description="Dyad counts file", required=true, validateWith=ReadablePathValidator.class)
    public WigFile dyadsFile;
    @Parameter(names={"-n", "--size"}, description="Nucleosome size (bp)")
    public int nucleosomeSize = 147;
    int halfNuc = 73;
    DescriptiveStatistics percusStats;
    DescriptiveStatistics occupancyStats;
    double maxOcc = 0.0;

    @Override
    public void setup() {
        this.addInputFile(this.dyadsFile);
        this.halfNuc = this.nucleosomeSize / 2;
        log.debug((Object)"Initializing statistics");
        this.percusStats = new DescriptiveStatistics();
        this.percusStats.setWindowSize(this.nucleosomeSize);
        this.occupancyStats = new DescriptiveStatistics();
        this.occupancyStats.setWindowSize(this.nucleosomeSize);
        log.debug((Object)"Computing maximum genome-wide occupancy (normalization factor)");
        for (String chr : this.dyadsFile.chromosomes()) {
            this.occupancyStats.clear();
            int bp = this.dyadsFile.getChrStart(chr);
            int stop = this.dyadsFile.getChrStop(chr);
            while (bp <= stop) {
                int chunkStart = bp;
                int chunkStop = Math.min(chunkStart + 300000 - 1, stop);
                try {
                    Iterator result = this.dyadsFile.query(chr, chunkStart, chunkStop);
                    float[] data = WigFile.flattenData((Iterator)result, (int)chunkStart, (int)chunkStop, (float)0.0f);
                    for (int i = 0; i < data.length; ++i) {
                        this.occupancyStats.addValue((double)data[i]);
                        if (!(this.occupancyStats.getSum() > this.maxOcc)) continue;
                        this.maxOcc = this.occupancyStats.getSum();
                    }
                }
                catch (WigFileException | IOException e) {
                    log.error((Object)"Error getting data from input Wig file");
                    e.printStackTrace();
                    throw new CommandLineToolException("Error getting data from input Wig file");
                }
                bp = chunkStop + 1;
            }
        }
        log.debug((Object)("Computed maximum genome-wide occupancy = " + this.maxOcc));
    }

    @Override
    public float[] compute(String chr, int start, int stop) throws IOException, WigFileException {
        this.percusStats.clear();
        this.occupancyStats.clear();
        int paddedStart = Math.max(start - this.nucleosomeSize, this.getMaxChrStart(this.inputs, chr));
        int paddedStop = Math.min(stop + this.nucleosomeSize, this.getMinChrStop(this.inputs, chr));
        Iterator result = this.dyadsFile.query(chr, paddedStart, paddedStop);
        float[] dyads = WigFile.flattenData((Iterator)result, (int)(start - this.nucleosomeSize), (int)(stop + this.nucleosomeSize), (float)0.0f);
        float[] occ = new float[dyads.length];
        int i = 0;
        while (i < dyads.length) {
            this.occupancyStats.addValue((double)dyads[i]);
            if (i - this.halfNuc >= 0) {
                occ[i - this.halfNuc] = (float)(this.occupancyStats.getSum() / this.maxOcc);
            }
            int n = i++;
            dyads[n] = (float)((double)dyads[n] / this.maxOcc);
        }
        for (i = this.halfNuc; i < 3 * this.halfNuc; ++i) {
            double summand = Math.log((1.0f - occ[i]) / (1.0f - occ[i] + dyads[i]));
            this.percusStats.addValue(summand);
        }
        float[] energies = new float[stop - start + 1];
        for (int i2 = this.nucleosomeSize; i2 < dyads.length - this.nucleosomeSize; ++i2) {
            double value = Math.log((1.0f - occ[i2] + dyads[i2]) / dyads[i2]);
            double summand = Math.log((1.0f - occ[i2 + this.halfNuc]) / (1.0f - occ[i2 + this.halfNuc] + dyads[i2 + this.halfNuc]));
            this.percusStats.addValue(summand);
            double summation = this.percusStats.getSum();
            energies[i2 - this.nucleosomeSize] = (float)(value + summation);
        }
        return energies;
    }

    public static void main(String[] args) {
        new PercusDecomposition().instanceMain(args);
    }
}

