/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.wigmath;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.io.WigFile;
import edu.unc.genomics.io.WigFileException;
import edu.unc.genomics.wigmath.WigMathTool;
import java.io.IOException;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class LogTransform
extends WigMathTool {
    private static final Logger log = Logger.getLogger(LogTransform.class);
    @Parameter(names={"-i", "--input"}, description="Input file", required=true)
    public WigFile inputFile;
    @Parameter(names={"-b", "--base"}, description="Logarithm base (default = 2)")
    public double base = 2.0;
    private double baseChange;

    @Override
    public void setup() {
        this.baseChange = Math.log(this.base);
        this.inputs.add(this.inputFile);
    }

    @Override
    public float[] compute(String chr, int start, int stop) throws IOException, WigFileException {
        log.debug((Object)("Computing difference for chunk " + chr + ":" + start + "-" + stop));
        Iterator data = this.inputFile.query(chr, start, stop);
        float[] result = WigFile.flattenData((Iterator)data, (int)start, (int)stop);
        for (int i = 0; i < result.length; ++i) {
            result[i] = (float)(Math.log(result[i]) / this.baseChange);
        }
        return result;
    }

    public static void main(String[] args) throws IOException, WigFileException {
        new LogTransform().instanceMain(args);
    }
}

