/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.search.score;

import it.unimi.dsi.fastutil.objects.Reference2DoubleMap;
import it.unimi.dsi.mg4j.index.Index;
import it.unimi.dsi.mg4j.search.DocumentIterator;
import it.unimi.dsi.mg4j.search.score.AbstractWeightedScorer;
import it.unimi.dsi.mg4j.search.score.DelegatingScorer;
import it.unimi.dsi.mg4j.search.visitor.CounterCollectionVisitor;
import it.unimi.dsi.mg4j.search.visitor.CounterSetupVisitor;
import it.unimi.dsi.mg4j.search.visitor.TermCollectionVisitor;
import java.io.IOException;
import org.apache.log4j.Logger;

public class CountScorer
extends AbstractWeightedScorer
implements DelegatingScorer {
    static Logger LOGGER = Logger.getLogger(CountScorer.class);
    private final CounterCollectionVisitor counterCollectionVisitor;
    private final CounterSetupVisitor counterSetupVisitor;
    private final TermCollectionVisitor termCollectionVisitor = new TermCollectionVisitor();

    public CountScorer() {
        this.counterSetupVisitor = new CounterSetupVisitor(this.termCollectionVisitor);
        this.counterCollectionVisitor = new CounterCollectionVisitor(this.counterSetupVisitor);
    }

    public double score() throws IOException {
        this.counterSetupVisitor.clear();
        this.documentIterator.acceptOnTruePaths(this.counterCollectionVisitor);
        double score = 0.0;
        int[] count = this.counterSetupVisitor.count;
        int[] indexNumber = this.counterSetupVisitor.indexNumber;
        int i = count.length;
        while (i-- != 0) {
            score += (double)count[i] * this.currWeight[indexNumber[i]];
        }
        return score;
    }

    public double score(Index index) {
        throw new UnsupportedOperationException();
    }

    public void wrap(DocumentIterator d) throws IOException {
        super.wrap(d);
        this.termCollectionVisitor.prepare();
        d.accept(this.termCollectionVisitor);
        this.currIndex = this.termCollectionVisitor.indices();
        this.counterSetupVisitor.prepare();
        d.accept(this.counterSetupVisitor);
    }

    public synchronized CountScorer copy() {
        CountScorer scorer = new CountScorer();
        scorer.setWeights((Reference2DoubleMap<Index>)this.index2Weight);
        return scorer;
    }

    public boolean usesIntervals() {
        return false;
    }
}

