/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.test;

import it.unimi.dsi.mg4j.util.MutableString;
import java.util.Random;

public class ReplaceSpeedTest {
    private static final Random RAND = new Random();
    private static final int MINCHAR = 65;
    private static final int MAXCHAR = 90;
    private static final int MAXLENGTH = 100;

    private ReplaceSpeedTest() {
    }

    public static char[] generateCharArray() {
        int n = RAND.nextInt(101);
        char[] res = new char[n];
        for (int i = 0; i < n; ++i) {
            res[i] = (char)(65 + RAND.nextInt(26));
        }
        return res;
    }

    public static MutableString generateMutableString() {
        return new MutableString(ReplaceSpeedTest.generateCharArray());
    }

    public static void main(String[] arg) {
        int n = Integer.parseInt(arg[0]);
        System.gc();
        System.gc();
        long start = -System.currentTimeMillis();
        char[] a = new char[]{'.', '-', '#', ' '};
        String[] b = new String[]{"pippo", "pluto", "paperino", "minnie"};
        int i = n;
        while (i-- != 0) {
            ReplaceSpeedTest.generateMutableString().replace(a, b);
        }
        System.err.println("Replaced new " + n + " words in " + (start + System.currentTimeMillis()) + " ms (" + (double)n * 1000.0 / (double)(start + System.currentTimeMillis()) + " words/s)");
        start = -System.currentTimeMillis();
        i = n;
        while (i-- != 0) {
        }
        System.err.println("Replaced old " + n + " words in " + (start + System.currentTimeMillis()) + " ms (" + (double)n * 1000.0 / (double)(start + System.currentTimeMillis()) + " words/s)");
    }
}

