/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.io;

import edu.unc.genomics.Interval;
import edu.unc.genomics.io.BigWigFile;
import edu.unc.genomics.io.TextWigFile;
import edu.unc.genomics.io.WigFileException;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.log4j.Logger;
import org.broad.igv.bbfile.WigItem;

public abstract class WigFile
implements Closeable {
    private static final Logger log = Logger.getLogger(WigFile.class);
    protected final Path p;

    protected WigFile(Path p) {
        log.debug((Object)("Initializing wig file: " + p.getFileName()));
        this.p = p;
    }

    public static WigFile autodetect(Path p) throws IOException, WigFileException {
        WigFile wig;
        if (BigWigFile.isBigWig(p)) {
            log.debug((Object)("Autodetected BigWig file type for: " + p));
            wig = new BigWigFile(p);
        } else {
            log.debug((Object)("Autodetected Wiggle file type for: " + p));
            wig = new TextWigFile(p);
        }
        return wig;
    }

    public static float[] flattenData(Iterator<WigItem> iter, int start, int stop, float defaultValue) {
        int low = Math.min(start, stop);
        int high = Math.max(start, stop);
        int length = high - low + 1;
        float[] data = new float[length];
        Arrays.fill(data, defaultValue);
        while (iter.hasNext()) {
            WigItem item = iter.next();
            for (int i = item.getStartBase(); i <= item.getEndBase(); ++i) {
                if (i < low || i > high) continue;
                data[i - low] = item.getWigValue();
            }
        }
        if (start > stop) {
            ArrayUtils.reverse((float[])data);
        }
        return data;
    }

    public static float[] flattenData(Iterator<WigItem> iter, int start, int stop) {
        return WigFile.flattenData(iter, start, stop, Float.NaN);
    }

    public Path getPath() {
        return this.p;
    }

    public Iterator<WigItem> query(Interval i) throws IOException, WigFileException {
        return this.query(i.getChr(), i.low(), i.high());
    }

    public abstract Iterator<WigItem> query(String var1, int var2, int var3) throws IOException, WigFileException;

    public abstract Set<String> chromosomes();

    public abstract int getChrStart(String var1);

    public abstract int getChrStop(String var1);

    public boolean includes(Interval i) {
        return this.includes(i.getChr(), i.getStart(), i.getStop());
    }

    public abstract boolean includes(String var1, int var2, int var3);

    public abstract boolean includes(String var1);

    public abstract long numBases();

    public abstract double total();

    public abstract double mean();

    public abstract double stdev();

    public abstract double min();

    public abstract double max();

    public abstract String toString();
}

